/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.fortuna.ical4j.model.CalendarPropertyAccessor;
import net.fortuna.ical4j.model.ComponentContainer;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.ConstraintViolationException;
import net.fortuna.ical4j.model.FluentCalendar;
import net.fortuna.ical4j.model.IndexedComponentList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyContainer;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.Prototype;
import net.fortuna.ical4j.model.component.CalendarComponent;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.parameter.TzId;
import net.fortuna.ical4j.model.property.Method;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.validate.AbstractCalendarValidatorFactory;
import net.fortuna.ical4j.validate.ValidationEntry;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.validate.Validator;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Calendar
implements Prototype<Calendar>,
Serializable,
PropertyContainer,
ComponentContainer<CalendarComponent>,
FluentCalendar,
CalendarPropertyAccessor {
    private static final long serialVersionUID = -1654118204678581940L;
    public static final BiFunction<Calendar, List<Property>, Calendar> MERGE_PROPERTIES = (c, list) -> {
        if (list != null && !list.isEmpty()) {
            list.forEach(p -> {
                switch (p.getName()) {
                    case "VERSION": 
                    case "METHOD": 
                    case "PRODID": {
                        c.replace(p.copy());
                        break;
                    }
                    default: {
                        c.add(p.copy());
                    }
                }
            });
        }
        return c;
    };
    public static final BiFunction<Calendar, List<CalendarComponent>, Calendar> MERGE_COMPONENTS = (c, list) -> {
        list.forEach(component -> {
            if (!c.getComponents().contains(component)) {
                c.add((CalendarComponent)component.copy());
            }
        });
        return c;
    };
    public static final String BEGIN = "BEGIN";
    public static final String VCALENDAR = "VCALENDAR";
    public static final String END = "END";
    private PropertyList properties;
    private ComponentList<CalendarComponent> components;
    private final Validator<Calendar> validator;

    public Calendar() {
        this(new PropertyList(), new ComponentList());
    }

    public Calendar(ComponentList<? extends CalendarComponent> components) {
        this(new PropertyList(), components);
    }

    public Calendar(PropertyList properties, ComponentList<? extends CalendarComponent> components) {
        this(properties, components, AbstractCalendarValidatorFactory.getInstance().newInstance());
    }

    public Calendar(PropertyList p, ComponentList<? extends CalendarComponent> c, Validator<Calendar> validator) {
        this.properties = p;
        this.components = new ComponentList<CalendarComponent>(c.getAll());
        this.validator = validator;
    }

    public Calendar(Calendar c) {
        this(c.properties, c.components);
    }

    public final String toString() {
        return "BEGIN:VCALENDAR\r\n" + this.properties + this.components + "END:VCALENDAR\r\n";
    }

    @Override
    public Calendar getFluentTarget() {
        return this;
    }

    public <C extends CalendarComponent> List<C> getComponents() {
        return ComponentContainer.super.getComponents(new String[0]);
    }

    @Override
    public final ComponentList<CalendarComponent> getComponentList() {
        return this.components;
    }

    @Override
    public void setComponentList(ComponentList<CalendarComponent> components) {
        this.components = components;
    }

    public <T extends Property> List<T> getProperties() {
        return CalendarPropertyAccessor.super.getProperties(new String[0]);
    }

    @Override
    public final PropertyList getPropertyList() {
        return this.properties;
    }

    @Override
    public void setPropertyList(PropertyList properties) {
        this.properties = properties;
    }

    public ValidationResult validate() throws ValidationException {
        return this.validate(true);
    }

    public ValidationResult validate(boolean recurse) throws ValidationException {
        ValidationResult result = this.validator.validate(this);
        if (recurse) {
            result = result.merge(this.validateProperties());
            result = result.merge(this.validateComponents());
        }
        return result;
    }

    private ValidationResult validateProperties() throws ValidationException {
        ValidationResult result = new ValidationResult(new ValidationEntry[0]);
        for (Property property : this.getProperties()) {
            result = result.merge(property.validate());
        }
        return result;
    }

    private ValidationResult validateComponents() throws ValidationException {
        ValidationResult result = new ValidationResult(new ValidationEntry[0]);
        Optional<Method> method = this.getMethod();
        if (method.isPresent()) {
            for (CalendarComponent c : this.getComponents()) {
                result = result.merge(c.validate(method.get()));
            }
        } else {
            for (CalendarComponent c : this.getComponents()) {
                result = result.merge(c.validate());
            }
        }
        return result;
    }

    @Override
    public final Calendar copy() {
        return new Calendar(new PropertyList(this.getProperties().parallelStream().map(Property::copy).collect(Collectors.toList())), new ComponentList(this.getComponents().parallelStream().map(c -> (CalendarComponent)c.copy()).collect(Collectors.toList())));
    }

    public Calendar merge(Calendar c2) {
        Calendar copy = this.copy();
        copy.with(MERGE_PROPERTIES, c2.getProperties());
        copy.with(MERGE_COMPONENTS, c2.getComponents());
        return copy;
    }

    public Calendar[] split() {
        if (this.getComponents().size() <= 1 || this.getComponents("VTIMEZONE").size() == this.getComponents().size()) {
            return new Calendar[]{this};
        }
        List timezoneList = this.getComponents("VTIMEZONE");
        IndexedComponentList timezones = new IndexedComponentList(timezoneList, "TZID");
        HashMap<Uid, Calendar> calendars = new HashMap<Uid, Calendar>();
        for (CalendarComponent c : this.getComponents()) {
            Optional<Uid> uid;
            if (c instanceof VTimeZone || !(uid = c.getUid()).isPresent()) continue;
            Calendar uidCal = (Calendar)calendars.get(uid.get());
            if (uidCal == null) {
                PropertyList splitProps = (PropertyList)this.getPropertyList().removeAll("METHOD");
                uidCal = new Calendar(splitProps, new ComponentList());
                calendars.put(uid.get(), uidCal);
            }
            for (Property p : c.getProperties()) {
                Optional tzid = p.getParameter("TZID");
                if (!tzid.isPresent()) continue;
                VTimeZone timezone = (VTimeZone)timezones.getComponent(((TzId)tzid.get()).getValue());
                if (uidCal.getComponents().contains(timezone)) continue;
                uidCal.add(timezone);
            }
            uidCal.add(c);
        }
        return (Calendar[])calendars.values().toArray(Calendar[]::new);
    }

    public Uid getUid() throws ConstraintViolationException {
        Property uid = null;
        for (CalendarComponent c : this.components.getAll()) {
            for (Property foundUid : c.getProperties("UID")) {
                if (uid != null && !uid.equals(foundUid)) {
                    throw new ConstraintViolationException("More than one UID found in calendar");
                }
                uid = (Uid)foundUid;
            }
        }
        if (uid == null) {
            throw new ConstraintViolationException("Calendar must specify a single unique identifier (UID)");
        }
        return uid;
    }

    public String getContentType(Charset charset) {
        StringBuilder b = new StringBuilder("text/calendar");
        Optional<Method> method = this.getMethod();
        if (method.isPresent()) {
            b.append("; method=");
            b.append(method.get().getValue());
        }
        if (charset != null) {
            b.append("; charset=");
            b.append(charset);
        }
        return b.toString();
    }

    public final boolean equals(Object arg0) {
        if (arg0 instanceof Calendar) {
            Calendar calendar = (Calendar)arg0;
            return new EqualsBuilder().append(this.getProperties(), calendar.getProperties()).append(this.components, calendar.components).isEquals();
        }
        return super.equals(arg0);
    }

    public final int hashCode() {
        return new HashCodeBuilder().append((Object)this.properties).append(this.components).toHashCode();
    }
}

