/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.fortuna.ical4j.model.TemporalAdapter;

public class CalendarDateFormat
implements Serializable {
    public static final CalendarDateFormat DATE_FORMAT = new CalendarDateFormat("yyyyMMdd", new LocalDateTemporalQuery());
    public static final CalendarDateFormat FLOATING_DATE_TIME_FORMAT = new CalendarDateFormat("yyyyMMdd'T'HHmmss", new LocalDateTimeTemporalQuery());
    public static final CalendarDateFormat UTC_DATE_TIME_FORMAT = new CalendarDateFormat("yyyyMMdd'T'HHmmss'Z'", new InstantTemporalQuery());
    public static final CalendarDateFormat RELAXED_DATE_TIME_FORMAT = new CalendarDateFormat("yyyyMMdd'T'HHmmss[X]", new OffsetDateTimeTemporalQuery(), new LocalDateTimeTemporalQuery());
    public static final CalendarDateFormat DEFAULT_PARSE_FORMAT = new CalendarDateFormat("yyyyMMdd['T'HHmmss[X]]", new OffsetDateTimeTemporalQuery(), new LocalDateTimeTemporalQuery(), new LocalDateTemporalQuery());
    private final String pattern;
    private volatile transient DateTimeFormatter formatter;
    private final TemporalQuery<? extends TemporalAccessor>[] parsers;

    @SafeVarargs
    public CalendarDateFormat(String pattern, TemporalQuery<? extends TemporalAccessor> ... parsers) {
        Objects.requireNonNull(pattern, "pattern");
        this.pattern = pattern;
        this.parsers = parsers;
    }

    @SafeVarargs
    public CalendarDateFormat(DateTimeFormatter formatter, TemporalQuery<? extends TemporalAccessor> ... parsers) {
        this("yyyyMMdd['T'HHmmss[X]]", parsers);
        this.formatter = formatter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DateTimeFormatter getFormatter() {
        if (this.formatter == null) {
            String string = this.pattern;
            synchronized (string) {
                if (this.formatter == null) {
                    this.formatter = DateTimeFormatter.ofPattern(this.pattern);
                    if (this.pattern.endsWith("'Z'")) {
                        this.formatter = this.formatter.withZone(ZoneOffset.UTC);
                    }
                }
            }
        }
        return this.formatter;
    }

    public TemporalAccessor parse(String dateString) {
        if (this.parsers.length > 1) {
            return this.getFormatter().parseBest(dateString, this.parsers);
        }
        if (this.parsers.length > 0) {
            return this.getFormatter().parse((CharSequence)dateString, this.parsers[0]);
        }
        return this.getFormatter().parse(dateString);
    }

    public ZonedDateTime parse(String dateString, ZoneId zoneId) {
        return ZonedDateTime.parse(dateString, this.getFormatter().withZone(zoneId));
    }

    public String format(TemporalAccessor date) {
        return this.getFormatter().format(date);
    }

    public String format(TemporalAccessor date, ZoneId zoneId) {
        return this.getFormatter().withZone(zoneId).format(date);
    }

    public static CalendarDateFormat from(List<? extends Temporal> list) {
        if (!list.isEmpty()) {
            return CalendarDateFormat.from(list.get(0));
        }
        return FLOATING_DATE_TIME_FORMAT;
    }

    public static CalendarDateFormat from(Temporal temporal) {
        if (TemporalAdapter.isUtc(temporal)) {
            return UTC_DATE_TIME_FORMAT;
        }
        if (!TemporalAdapter.isDateTimePrecision(temporal)) {
            return DATE_FORMAT;
        }
        return FLOATING_DATE_TIME_FORMAT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CalendarDateFormat that = (CalendarDateFormat)o;
        return this.pattern.equals(that.pattern) && Arrays.equals(this.parsers, that.parsers);
    }

    public int hashCode() {
        int result = Objects.hash(this.pattern);
        result = 31 * result + Arrays.hashCode(this.parsers);
        return result;
    }

    public static class LocalDateTemporalQuery
    implements TemporalQuery<LocalDate>,
    Serializable {
        @Override
        public LocalDate queryFrom(TemporalAccessor temporal) {
            return LocalDate.from(temporal);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj != null && this.getClass() == obj.getClass();
        }
    }

    public static class LocalDateTimeTemporalQuery
    implements TemporalQuery<LocalDateTime>,
    Serializable {
        @Override
        public LocalDateTime queryFrom(TemporalAccessor temporal) {
            return LocalDateTime.from(temporal);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj != null && this.getClass() == obj.getClass();
        }
    }

    public static class InstantTemporalQuery
    implements TemporalQuery<Instant>,
    Serializable {
        @Override
        public Instant queryFrom(TemporalAccessor temporal) {
            return Instant.from(temporal);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj != null && this.getClass() == obj.getClass();
        }
    }

    public static class OffsetDateTimeTemporalQuery
    implements TemporalQuery<OffsetDateTime>,
    Serializable {
        @Override
        public OffsetDateTime queryFrom(TemporalAccessor temporal) {
            return OffsetDateTime.from(temporal);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj != null && this.getClass() == obj.getClass();
        }
    }
}

