/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.time.Instant;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import net.fortuna.ical4j.model.PropertyContainer;
import net.fortuna.ical4j.model.property.Created;
import net.fortuna.ical4j.model.property.DtStamp;
import net.fortuna.ical4j.model.property.LastModified;
import net.fortuna.ical4j.model.property.Sequence;

public interface ChangeManagementPropertyModifiers {
    public static final BiFunction<PropertyContainer, Instant, PropertyContainer> CREATED = (c, p) -> {
        if (p != null) {
            c.replace(new Created((Instant)p));
        }
        return c;
    };
    public static final BiFunction<PropertyContainer, Instant, PropertyContainer> DTSTAMP = (c, p) -> {
        if (p != null) {
            c.replace(new DtStamp((Instant)p));
        }
        return c;
    };
    public static final BiFunction<PropertyContainer, Instant, PropertyContainer> LAST_MODIFIED = (c, p) -> {
        if (p != null) {
            c.replace(new LastModified((Instant)p));
        }
        return c;
    };
    public static final BiFunction<PropertyContainer, Integer, PropertyContainer> SEQUENCE = (c, p) -> {
        if (p != null) {
            c.replace(new Sequence((int)p));
        }
        return c;
    };
    public static final UnaryOperator<PropertyContainer> SEQUENCE_INCREMENT = p -> {
        Optional sequence = p.getProperty("SEQUENCE");
        if (sequence.isPresent()) {
            SEQUENCE.apply((PropertyContainer)p, ((Sequence)sequence.get()).getSequenceNo() + 1);
        } else {
            SEQUENCE.apply((PropertyContainer)p, 0);
        }
        return p;
    };
}

