/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.io.Serializable;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.fortuna.ical4j.model.ComponentFactory;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.FluentComponent;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyContainer;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.Prototype;
import net.fortuna.ical4j.model.TemporalAmountAdapter;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.DateListProperty;
import net.fortuna.ical4j.model.property.DateProperty;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Duration;
import net.fortuna.ical4j.model.property.ExRule;
import net.fortuna.ical4j.model.property.RDate;
import net.fortuna.ical4j.model.property.RRule;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.validate.ValidationEntry;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public abstract class Component
extends Content
implements Prototype<Component>,
Serializable,
PropertyContainer,
FluentComponent,
Comparable<Component> {
    private static final long serialVersionUID = 4943193483665822201L;
    public static final String BEGIN = "BEGIN";
    public static final String END = "END";
    public static final String PARTICIPANT = "PARTICIPANT";
    public static final String VLOCATION = "VLOCATION";
    public static final String VRESOURCE = "VRESOURCE";
    public static final String VEVENT = "VEVENT";
    public static final String VTODO = "VTODO";
    public static final String VJOURNAL = "VJOURNAL";
    public static final String VFREEBUSY = "VFREEBUSY";
    public static final String VTIMEZONE = "VTIMEZONE";
    public static final String VALARM = "VALARM";
    public static final String VAVAILABILITY = "VAVAILABILITY";
    public static final String VVENUE = "VVENUE";
    public static final String AVAILABLE = "AVAILABLE";
    public static final String EXPERIMENTAL_PREFIX = "X-";
    private final String name;
    protected PropertyList properties;
    protected ComponentList<? extends Component> components;

    protected Component(String s) {
        this(s, new PropertyList(), new ComponentList());
    }

    protected Component(String s, PropertyList p) {
        this(s, p, new ComponentList());
    }

    protected Component(String s, PropertyList p, ComponentList<? extends Component> c) {
        this.name = s;
        this.properties = p;
        this.components = c;
    }

    public String toString() {
        return "BEGIN:" + this.name + "\r\n" + this.properties + this.components + "END:" + this.name + "\r\n";
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.properties.toString();
    }

    public <T extends Property> List<T> getProperties() {
        return PropertyContainer.super.getProperties(new String[0]);
    }

    @Override
    public Component getFluentTarget() {
        return this;
    }

    @Override
    public final PropertyList getPropertyList() {
        return this.properties;
    }

    @Override
    public void setPropertyList(PropertyList properties) {
        this.properties = properties;
    }

    public Optional<Uid> getUid() {
        return this.getProperty("UID");
    }

    public ValidationResult validate() throws ValidationException {
        return this.validate(true);
    }

    public abstract ValidationResult validate(boolean var1) throws ValidationException;

    protected ValidationResult validateProperties() throws ValidationException {
        ValidationResult result = new ValidationResult(new ValidationEntry[0]);
        for (Property property : this.getProperties()) {
            result = result.merge(property.validate());
        }
        return result;
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof Component) {
            Component c = (Component)arg0;
            return new EqualsBuilder().append((Object)this.getName(), (Object)c.getName()).append(this.getProperties(), c.getProperties()).isEquals();
        }
        return super.equals(arg0);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getName()).append(this.getProperties()).toHashCode();
    }

    protected abstract ComponentFactory<? extends Component> newFactory();

    @Override
    public Component copy() {
        return this.newFactory().createComponent(new PropertyList(this.getProperties().parallelStream().map(Prototype::copy).collect(Collectors.toList())));
    }

    public final <T extends Temporal> Set<Period<T>> calculateRecurrenceSet(Period<? extends Temporal> period) {
        TreeSet<Period<Period>> recurrenceSet = new TreeSet<Period<Period>>();
        Optional start = this.getProperty("DTSTART");
        Optional end = this.getProperty("DTEND");
        if (end.isEmpty()) {
            end = this.getProperty("DUE");
        }
        Optional<Duration> duration = this.getProperty("DURATION");
        if (start.isEmpty()) {
            return Collections.emptySet();
        }
        TemporalAmount rDuration = end.isEmpty() && duration.isEmpty() ? java.time.Duration.ZERO : (duration.isEmpty() ? TemporalAmountAdapter.between(((DtStart)start.get()).getDate(), ((DateProperty)end.get()).getDate()).getDuration() : ((Duration)duration.get()).getDuration());
        List rDates = this.getProperties("RDATE");
        for (Property p2 : rDates) {
            Optional value2 = p2.getParameter("VALUE");
            if (value2.equals(Optional.of(Value.PERIOD))) {
                recurrenceSet.addAll(((RDate)p2).getPeriods().orElse(Collections.emptySet()).parallelStream().filter(period::intersects).collect(Collectors.toList()));
                continue;
            }
            recurrenceSet.addAll(((DateListProperty)p2).getDates().parallelStream().filter(period::includes).map(d -> new Period<Temporal>((Temporal)d, rDuration)).collect(Collectors.toList()));
        }
        Temporal startMinusDuration = period.getStart().minus(rDuration);
        Object seed = ((DtStart)start.get()).getDate();
        List rRules = this.getProperties("RRULE");
        if (!rRules.isEmpty()) {
            recurrenceSet.addAll(rRules.stream().map(r -> ((RRule)r).getRecur().getDates((Temporal)seed, startMinusDuration, (Temporal)period.getEnd())).flatMap(Collection::stream).map(rruleDate -> new Period<Temporal>((Temporal)rruleDate, rDuration)).collect(Collectors.toList()));
        } else {
            Period startPeriod = end.isPresent() ? new Period(seed, ((DateProperty)end.get()).getDate()) : duration.map(value -> new Period<Temporal>((Temporal)seed, value.getDuration())).orElseGet(() -> new Period<Temporal>((Temporal)seed, new Duration(rDuration).getDuration()));
            if (period.intersects(startPeriod)) {
                recurrenceSet.add(startPeriod);
            }
        }
        List exDateProps = this.getProperties("EXDATE");
        List exDates = exDateProps.stream().map(p -> ((DateListProperty)p).getDates()).flatMap(Collection::stream).collect(Collectors.toList());
        recurrenceSet.removeIf((? super E recurrence) -> exDates.contains(recurrence.getStart()));
        List exRules = this.getProperties("EXRULE");
        List exRuleDates = exRules.stream().map(e -> ((ExRule)e).getRecur().getDates((Temporal)seed, (Period<Temporal>)period)).flatMap(Collection::stream).collect(Collectors.toList());
        recurrenceSet.removeIf((? super E recurrence) -> exRuleDates.contains(recurrence.getStart()));
        recurrenceSet.forEach(p -> p.setComponent(this));
        return recurrenceSet;
    }

    @Override
    public int compareTo(Component o) {
        if (this.equals(o)) {
            return 0;
        }
        return Comparator.comparing(Component::getName).thenComparing(Component::getPropertyList).compare(this, o);
    }
}

