/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fortuna.ical4j.model.AbstractContentBuilder;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentFactory;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.XComponent;

public class ComponentBuilder<T extends Component>
extends AbstractContentBuilder {
    private final List<ComponentFactory<?>> factories;
    private String name;
    private final List<Property> properties = new ArrayList<Property>();
    private final List<Component> subComponents = new ArrayList<Component>();

    public ComponentBuilder() {
        this(true);
    }

    public ComponentBuilder(boolean allowIllegalNames) {
        this(Collections.emptyList(), allowIllegalNames);
    }

    public ComponentBuilder(List<ComponentFactory<?>> factories) {
        this(factories, true);
    }

    public ComponentBuilder(List<ComponentFactory<?>> factories, boolean allowIllegalNames) {
        super(allowIllegalNames);
        this.factories = factories;
    }

    public ComponentBuilder<?> name(String name) {
        this.name = name.toUpperCase();
        return this;
    }

    public boolean hasName(String name) {
        return name.equals(this.name);
    }

    public ComponentBuilder<?> property(Property property) {
        this.properties.add(property);
        return this;
    }

    public ComponentBuilder<?> subComponent(Component subComponent) {
        this.subComponents.add(subComponent);
        return this;
    }

    public T build() {
        XComponent component = null;
        for (ComponentFactory<?> factory : this.factories) {
            if (!factory.supports(this.name)) continue;
            if (!this.subComponents.isEmpty()) {
                component = factory.createComponent(new PropertyList(this.properties), new ComponentList<Component>(this.subComponents));
                continue;
            }
            component = factory.createComponent(new PropertyList(this.properties));
        }
        if (component == null) {
            if (this.isExperimentalName(this.name)) {
                component = new XComponent(this.name, new PropertyList(this.properties));
            } else if (this.allowIllegalNames()) {
                component = new XComponent(this.name, new PropertyList(this.properties));
            } else {
                throw new IllegalArgumentException("Unsupported component [" + this.name + "]");
            }
        }
        return (T)component;
    }
}

