/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ContentCollection;
import org.jetbrains.annotations.NotNull;

public class ComponentList<T extends Component>
implements ContentCollection<T>,
Comparable<ComponentList<? extends Component>> {
    private final List<T> components;

    public ComponentList() {
        this(Collections.emptyList());
    }

    public ComponentList(List<? extends T> components) {
        this.components = Collections.unmodifiableList(components);
    }

    @Override
    public ContentCollection<T> add(@NotNull T content) {
        ArrayList<T> copy = new ArrayList<T>(this.components);
        copy.add(content);
        return new ComponentList<T>(copy);
    }

    @Override
    public ContentCollection<T> addAll(@NotNull Collection<T> content) {
        ArrayList<T> copy = new ArrayList<T>(this.components);
        copy.addAll(content);
        return new ComponentList<T>(copy);
    }

    @Override
    public ContentCollection<T> remove(T content) {
        ArrayList<T> copy = new ArrayList<T>(this.components);
        if (copy.remove(content)) {
            return new ComponentList<T>(copy);
        }
        return this;
    }

    @Override
    public ContentCollection<T> removeAll(String ... name) {
        List<String> names = Arrays.asList(name);
        return this.removeIf(c -> names.contains(c.getName()));
    }

    @Override
    public ContentCollection<T> removeIf(Predicate<T> filter) {
        ArrayList<T> copy = new ArrayList<T>(this.components);
        if (copy.removeIf(filter)) {
            return new ComponentList<T>(copy);
        }
        return this;
    }

    @Override
    public ContentCollection<T> replace(@NotNull T content) {
        ArrayList<T> copy = new ArrayList<T>(this.components);
        copy.removeIf((? super E c) -> c.getName().equals(content.getName()));
        copy.add(content);
        return new ComponentList<T>(copy);
    }

    @Override
    public List<T> getAll() {
        return this.components;
    }

    public final String toString() {
        return this.components.stream().map(Component::toString).collect(Collectors.joining(""));
    }

    @Deprecated
    public final <R extends T> Optional<R> getComponent(String aName) {
        return this.getFirst(aName);
    }

    @Deprecated
    public final <C extends T> List<C> getComponents(String ... name) {
        return this.get(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentList that = (ComponentList)o;
        return Objects.equals(this.components, that.components);
    }

    public int hashCode() {
        return Objects.hash(this.components);
    }

    @Override
    public int compareTo(ComponentList<? extends Component> o) {
        if (this.components.equals(o.components)) {
            return 0;
        }
        int retval = this.components.size() - o.components.size();
        if (retval != 0) {
            return retval;
        }
        return this.components.stream().filter(o.components::contains).mapToInt(c -> c.compareTo((Component)o.components.get(o.components.indexOf(c)))).sum();
    }
}

