/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fortuna.ical4j.model.ConstraintViolationException;
import net.fortuna.ical4j.model.Content;

public interface ContentCollection<T extends Content>
extends Serializable {
    public ContentCollection<T> add(T var1);

    public ContentCollection<T> addAll(Collection<T> var1);

    public ContentCollection<T> remove(T var1);

    public ContentCollection<T> removeAll(String ... var1);

    public ContentCollection<T> removeIf(Predicate<T> var1);

    public ContentCollection<T> replace(T var1);

    public List<T> getAll();

    default public <R extends T> List<R> get(String ... names) {
        if (names.length > 0) {
            List filter = Arrays.stream(names).map(String::toUpperCase).collect(Collectors.toList());
            return this.getAll().stream().filter(c -> filter.contains(c.getName())).map(c -> c).collect(Collectors.toList());
        }
        return this.getAll();
    }

    default public <R extends T> Optional<R> getFirst(String name) {
        return this.getAll().stream().filter(c -> c.getName().equalsIgnoreCase(name)).findFirst();
    }

    default public <R extends T> R getRequired(String name) throws ConstraintViolationException {
        return (R)((Content)this.getFirst(name).orElseThrow(() -> new ConstraintViolationException(String.format("Missing required %s", name))));
    }
}

