/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.io.Serializable;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fortuna.ical4j.model.TemporalAdapter;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.parameter.TzId;

public class DateList<T extends Temporal>
implements Serializable {
    private static final long serialVersionUID = -3700862452550012357L;
    public static final DateList EMPTY_LIST = new DateList();
    private final List<TemporalAdapter<T>> dates;

    public DateList() {
        this.dates = Collections.emptyList();
    }

    public DateList(T ... dates) {
        this.dates = Arrays.stream(dates).map(TemporalAdapter::new).collect(Collectors.toList());
    }

    public DateList(Collection<T> dates) {
        this.dates = dates.stream().map(TemporalAdapter::new).collect(Collectors.toList());
    }

    public DateList(TimeZoneRegistry timeZoneRegistry, T ... dates) {
        this.dates = Arrays.stream(dates).map(date -> new TemporalAdapter<Temporal>((Temporal)date, timeZoneRegistry)).collect(Collectors.toList());
    }

    private DateList(List<TemporalAdapter<T>> dates) {
        this.dates = dates;
    }

    public static DateList<? extends Temporal> parse(String value) {
        if (value == null || value.isEmpty()) {
            return DateList.emptyList();
        }
        List dates = ((Stream)Arrays.stream(value.split("\\s*,\\s*")).parallel()).map(TemporalAdapter::parse).collect(Collectors.toList());
        return new DateList(dates);
    }

    public static DateList<? extends Temporal> parse(String value, ZoneId zoneId) {
        if (value == null || value.isEmpty()) {
            return DateList.emptyList();
        }
        List dates = ((Stream)Arrays.stream(value.split("\\s*,\\s*")).parallel()).map(s -> TemporalAdapter.parse(s, zoneId)).collect(Collectors.toList());
        return new DateList(dates);
    }

    public static DateList<ZonedDateTime> parse(String value, TzId tzId, TimeZoneRegistry timeZoneRegistry) {
        if (value == null || value.isEmpty()) {
            return DateList.emptyList();
        }
        List dates = ((Stream)Arrays.stream(value.split("\\s*,\\s*")).parallel()).map(s -> TemporalAdapter.parse(s, tzId, timeZoneRegistry)).collect(Collectors.toList());
        return new DateList<ZonedDateTime>(dates);
    }

    public static <T extends Temporal> DateList<T> emptyList() {
        return EMPTY_LIST;
    }

    public String toString() {
        if (this.dates.isEmpty()) {
            return "";
        }
        return this.dates.stream().map(TemporalAdapter::toString).collect(Collectors.joining(","));
    }

    public String toString(ZoneId zoneId) {
        if (this.dates.isEmpty()) {
            return "";
        }
        return this.dates.stream().map(date -> date.toString(zoneId)).collect(Collectors.joining(","));
    }

    public final DateList<T> add(T date) {
        ArrayList<TemporalAdapter<T>> copy = new ArrayList<TemporalAdapter<T>>(this.dates);
        copy.add(new TemporalAdapter<T>(date));
        return new DateList<T>(copy);
    }

    public final DateList<T> addAll(Collection<? extends T> arg0) {
        ArrayList<TemporalAdapter<T>> copy = new ArrayList<TemporalAdapter<T>>(this.dates);
        copy.addAll(arg0.stream().map(TemporalAdapter::new).collect(Collectors.toList()));
        return new DateList<T>(copy);
    }

    public List<T> getDates() {
        return this.dates.stream().map(TemporalAdapter::getTemporal).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateList dateList = (DateList)o;
        return Objects.equals(this.dates, dateList.dates);
    }

    public int hashCode() {
        return Objects.hash(this.dates);
    }
}

