/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.io.IOException;
import java.time.zone.ZoneRules;
import java.time.zone.ZoneRulesProvider;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.TimeZoneLoader;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.ZoneRulesBuilder;
import net.fortuna.ical4j.model.component.VTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultZoneRulesProvider
extends ZoneRulesProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultZoneRulesProvider.class);
    private static final String DEFAULT_RESOURCE_PREFIX = "zoneinfo/";
    private final TimeZoneLoader zoneLoader;
    private final Map<String, ZoneRules> zoneRulesMap;

    public DefaultZoneRulesProvider() {
        this(new TimeZoneLoader(DEFAULT_RESOURCE_PREFIX), TimeZoneRegistry.ZONE_IDS);
    }

    public DefaultZoneRulesProvider(TimeZoneLoader timeZoneLoader, Map<String, String> zoneIdMap) {
        this.zoneLoader = timeZoneLoader;
        for (String id : this.zoneLoader.getAvailableIDs()) {
            zoneIdMap.put("ical4j~" + UUID.randomUUID(), id);
        }
        this.zoneRulesMap = new ConcurrentHashMap<String, ZoneRules>();
    }

    @Override
    protected Set<String> provideZoneIds() {
        return TimeZoneRegistry.ZONE_IDS.keySet();
    }

    @Override
    protected ZoneRules provideRules(String zoneId, boolean forCaching) {
        ZoneRules retVal = null;
        if (this.zoneRulesMap.containsKey(zoneId)) {
            retVal = this.zoneRulesMap.get(zoneId);
        } else {
            try {
                String localZoneId = TimeZoneRegistry.ZONE_IDS.get(zoneId);
                VTimeZone vTimeZone = this.zoneLoader.loadVTimeZone(localZoneId);
                retVal = new ZoneRulesBuilder().vTimeZone(vTimeZone).build();
                this.zoneRulesMap.put(zoneId, retVal);
            }
            catch (IOException | ParserException e) {
                LOG.error("Error loading zone rules", (Throwable)e);
            }
        }
        return retVal;
    }

    @Override
    protected NavigableMap<String, ZoneRules> provideVersions(String zoneId) {
        TreeMap<String, ZoneRules> retVal = new TreeMap<String, ZoneRules>();
        if (this.zoneRulesMap.containsKey(zoneId)) {
            retVal.put(zoneId, this.zoneRulesMap.get(zoneId));
        }
        return retVal;
    }

    @Override
    protected boolean provideRefresh() {
        return super.provideRefresh();
    }
}

