/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Property;

public class IndexedComponentList<T extends Component> {
    private final Map<String, List<T>> index;

    public IndexedComponentList(List<T> list, String propertyName) {
        HashMap<String, List> indexedComponents = new HashMap<String, List>();
        for (Component component : list) {
            for (Property property : component.getProperties(propertyName)) {
                List components = indexedComponents.computeIfAbsent(property.getValue(), k -> new ArrayList());
                components.add(component);
            }
        }
        indexedComponents.keySet().forEach(p -> indexedComponents.put((String)p, Collections.unmodifiableList((List)indexedComponents.get(p))));
        this.index = Collections.unmodifiableMap(indexedComponents);
    }

    public List<T> getComponents(String propertyValue) {
        List<T> components = this.index.get(propertyValue);
        if (components == null) {
            components = Collections.emptyList();
        }
        return components;
    }

    public T getComponent(String propertyValue) {
        List<T> components = this.getComponents(propertyValue);
        if (!components.isEmpty()) {
            return (T)((Component)components.get(0));
        }
        return null;
    }
}

