/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.io.Serializable;
import java.util.Objects;

public class Month
implements Serializable {
    private final int monthOfYear;
    private final boolean leapMonth;

    public Month(int monthOfYear) {
        this(monthOfYear, false);
    }

    public Month(int monthOfYear, boolean leapMonth) {
        this.monthOfYear = monthOfYear;
        this.leapMonth = leapMonth;
    }

    public int getMonthOfYear() {
        return this.monthOfYear;
    }

    public boolean isLeapMonth() {
        return this.leapMonth;
    }

    public static Month parse(String monthString) {
        if (monthString.endsWith("L")) {
            return new Month(Integer.parseInt(monthString.substring(0, monthString.length() - 1)), true);
        }
        return new Month(Integer.parseInt(monthString));
    }

    public static Month valueOf(int monthOfYear) {
        return new Month(monthOfYear);
    }

    public static Month from(java.time.Month month) {
        return new Month(month.getValue());
    }

    public String toString() {
        if (this.leapMonth) {
            return this.monthOfYear + "L";
        }
        return String.valueOf(this.monthOfYear);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Month month = (Month)o;
        return this.monthOfYear == month.monthOfYear && this.leapMonth == month.leapMonth;
    }

    public int hashCode() {
        return Objects.hash(this.monthOfYear, this.leapMonth);
    }
}

