/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.time.temporal.ChronoField;
import java.time.temporal.ValueRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fortuna.ical4j.model.Month;

public class MonthList
extends ArrayList<Month> {
    private final ValueRange valueRange;

    public MonthList() {
        this(ChronoField.MONTH_OF_YEAR.range());
    }

    public MonthList(ValueRange range) {
        this.valueRange = range;
    }

    public MonthList(String aString) {
        this(aString, ChronoField.MONTH_OF_YEAR.range());
    }

    public MonthList(String aString, ValueRange valueRange) {
        this(valueRange);
        this.addAll(Arrays.stream(aString.split("\\s*,\\s*")).map(Month::parse).collect(Collectors.toList()));
    }

    public MonthList(Collection<Month> values, ValueRange valueRange) {
        this(valueRange);
        this.addAll((Collection<? extends Month>)values);
    }

    @Override
    public final boolean add(Month month) {
        if (!this.valueRange.isValidValue(month.getMonthOfYear())) {
            throw new IllegalArgumentException("Value not in range [" + this.valueRange + "]: " + month);
        }
        return super.add(month);
    }

    @Override
    public boolean addAll(Collection<? extends Month> c) {
        Optional<Month> invalidMonth = c.stream().filter(m -> !this.valueRange.isValidValue(m.getMonthOfYear())).findFirst();
        if (invalidMonth.isPresent()) {
            throw new IllegalArgumentException("Value not in range [" + this.valueRange + "]: " + invalidMonth);
        }
        return super.addAll(c);
    }

    @Override
    public final String toString() {
        return this.stream().map(Object::toString).collect(Collectors.joining(","));
    }
}

