/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.io.Serializable;
import java.time.temporal.ValueRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fortuna.ical4j.util.Numbers;

public class NumberList
extends ArrayList<Integer>
implements Serializable {
    private static final long serialVersionUID = -1667481795613729889L;
    private final ValueRange range;
    private final boolean allowsNegativeValues;

    public NumberList() {
        this(ValueRange.of(Integer.MIN_VALUE, Integer.MAX_VALUE), true);
    }

    public NumberList(ValueRange valueRange, boolean allowsNegativeValues) {
        this.range = valueRange;
        this.allowsNegativeValues = allowsNegativeValues;
    }

    @Deprecated
    public NumberList(int minValue, int maxValue, boolean allowsNegativeValues) {
        this(ValueRange.of(minValue, maxValue), allowsNegativeValues);
    }

    public NumberList(String aString) {
        this(aString, ValueRange.of(Integer.MIN_VALUE, Integer.MAX_VALUE), true);
    }

    public NumberList(String aString, ValueRange valueRange, boolean allowsNegativeValues) {
        this(valueRange, allowsNegativeValues);
        this.addAll(Arrays.stream(aString.split("\\s*,\\s*")).map(Numbers::parseInt).collect(Collectors.toList()));
    }

    public NumberList(Collection<Integer> values, ValueRange valueRange, boolean allowsNegativeValues) {
        this(valueRange, allowsNegativeValues);
        this.addAll((Collection<? extends Integer>)values);
    }

    @Deprecated
    public NumberList(String aString, int minValue, int maxValue, boolean allowsNegativeValues) {
        this(minValue, maxValue, allowsNegativeValues);
        this.addAll(((Stream)Arrays.stream(aString.split("\\s*,\\s*")).parallel()).map(Numbers::parseInt).collect(Collectors.toList()));
    }

    @Override
    public final boolean add(Integer aNumber) {
        int abs = aNumber;
        if ((abs >> 31 | -abs >>> 31) < 0) {
            if (!this.allowsNegativeValues) {
                throw new IllegalArgumentException("Negative value not allowed: " + aNumber);
            }
            abs = Math.abs(abs);
        }
        if (!this.range.isValidIntValue(abs)) {
            throw new IllegalArgumentException("Value not in range [" + this.range + "]: " + aNumber);
        }
        return super.add(aNumber);
    }

    @Override
    public boolean addAll(Collection<? extends Integer> c) {
        Optional<Integer> negativeValue = c.stream().filter(v -> (v >> 31 | -v.intValue() >>> 31) < 0).findFirst();
        if (!this.allowsNegativeValues && negativeValue.isPresent()) {
            throw new IllegalArgumentException("Negative value not allowed: " + negativeValue.get());
        }
        Optional<Integer> invalidValue = c.stream().filter(v -> !this.range.isValidValue(Math.abs(v))).findFirst();
        if (invalidValue.isPresent()) {
            throw new IllegalArgumentException("Value not in range [" + this.range + "]: " + invalidValue);
        }
        return super.addAll(c);
    }

    @Override
    public final String toString() {
        return NumberList.toString(this);
    }

    public static String toString(List<Integer> list) {
        return list.stream().map(Object::toString).collect(Collectors.joining(","));
    }

    public static NumberList parse(String numberString) {
        NumberList retVal = new NumberList();
        retVal.addAll(((Stream)Arrays.stream(numberString.split("\\s*,\\s*")).parallel()).map(Numbers::parseInt).collect(Collectors.toList()));
        return retVal;
    }
}

