/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.util.Comparator;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Encodable;
import net.fortuna.ical4j.model.ParameterCodec;
import net.fortuna.ical4j.util.Strings;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jetbrains.annotations.NotNull;

public abstract class Parameter
extends Content
implements Comparable<Parameter> {
    private static final long serialVersionUID = -2058497904769713528L;
    public static final String ABBREV = "ABBREV";
    public static final String ALTREP = "ALTREP";
    public static final String CN = "CN";
    public static final String CUTYPE = "CUTYPE";
    public static final String DELEGATED_FROM = "DELEGATED-FROM";
    public static final String DELEGATED_TO = "DELEGATED-TO";
    public static final String DERIVED = "DERIVED";
    public static final String DIR = "DIR";
    public static final String DISPLAY = "DISPLAY";
    public static final String EMAIL = "EMAIL";
    public static final String ENCODING = "ENCODING";
    public static final String FEATURE = "FEATURE";
    public static final String FMTTYPE = "FMTTYPE";
    public static final String FBTYPE = "FBTYPE";
    public static final String LABEL = "LABEL";
    public static final String LANGUAGE = "LANGUAGE";
    public static final String MEMBER = "MEMBER";
    public static final String ORDER = "ORDER";
    public static final String PARTSTAT = "PARTSTAT";
    public static final String RANGE = "RANGE";
    public static final String RELATED = "RELATED";
    public static final String RELTYPE = "RELTYPE";
    public static final String ROLE = "ROLE";
    public static final String RSVP = "RSVP";
    public static final String SCHEDULE_AGENT = "SCHEDULE-AGENT";
    public static final String SCHEDULE_STATUS = "SCHEDULE-STATUS";
    public static final String SCHEMA = "SCHEMA";
    public static final String SENT_BY = "SENT-BY";
    public static final String TYPE = "TYPE";
    public static final String TZID = "TZID";
    public static final String VALUE = "VALUE";
    public static final String VVENUE = "VVENUE";
    public static final String EXPERIMENTAL_PREFIX = "X-";
    private final String name;

    public Parameter(String aName) {
        this.name = aName;
    }

    public Parameter(@NotNull Enum<?> name) {
        this(name.toString());
    }

    public final String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getName());
        if (this.getValue() != null) {
            String value;
            b.append('=');
            if (this instanceof Encodable) {
                try {
                    value = ParameterCodec.INSTANCE.encode(this.getValue());
                }
                catch (EncoderException e) {
                    value = this.getValue();
                }
            } else {
                value = this.getValue();
            }
            b.append(Strings.valueOf(value));
        }
        return b.toString();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public final boolean equals(Object arg0) {
        if (arg0 instanceof Parameter) {
            Parameter p = (Parameter)arg0;
            return new EqualsBuilder().append((Object)this.getName(), (Object)p.getName()).append((Object)this.getValue(), (Object)p.getValue()).isEquals();
        }
        return super.equals(arg0);
    }

    public final int hashCode() {
        return new HashCodeBuilder().append((Object)this.getName().toUpperCase()).append((Object)this.getValue()).toHashCode();
    }

    @Override
    public int compareTo(Parameter o) {
        if (this.equals(o)) {
            return 0;
        }
        return Comparator.comparing(Parameter::getName).thenComparing(Content::getValue).compare(this, o);
    }
}

