/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.util.ArrayList;
import java.util.List;
import net.fortuna.ical4j.model.AbstractContentBuilder;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterCodec;
import net.fortuna.ical4j.model.ParameterFactory;
import net.fortuna.ical4j.model.parameter.XParameter;
import org.apache.commons.codec.DecoderException;

public class ParameterBuilder
extends AbstractContentBuilder {
    private final List<ParameterFactory<?>> factories;
    private String name;
    private String value;

    public ParameterBuilder() {
        this(new ArrayList<ParameterFactory<? extends Parameter>>());
    }

    public ParameterBuilder(List<ParameterFactory<? extends Parameter>> factories) {
        this.factories = factories;
    }

    @Deprecated
    public ParameterBuilder factories(List<ParameterFactory<?>> factories) {
        this.factories.clear();
        this.factories.addAll(factories);
        return this;
    }

    public ParameterBuilder name(String name) {
        this.name = name.toUpperCase();
        return this;
    }

    public ParameterBuilder value(String value) {
        this.value = value;
        return this;
    }

    public Parameter build() {
        String decodedValue;
        XParameter parameter = null;
        try {
            decodedValue = ParameterCodec.INSTANCE.decode(this.value);
        }
        catch (DecoderException e) {
            decodedValue = this.value;
        }
        for (ParameterFactory<?> factory : this.factories) {
            if (!factory.supports(this.name)) continue;
            parameter = (XParameter)factory.createParameter(decodedValue);
            break;
        }
        if (parameter == null) {
            if (this.isExperimentalName(this.name)) {
                parameter = new XParameter(this.name, decodedValue);
            } else if (this.allowIllegalNames()) {
                parameter = new XParameter(this.name, decodedValue);
            } else {
                throw new IllegalArgumentException(String.format("Unsupported parameter name: %s", this.name));
            }
        }
        return parameter;
    }
}

