/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.util.regex.Pattern;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringDecoder;
import org.apache.commons.codec.StringEncoder;

public class ParameterCodec
implements StringEncoder,
StringDecoder {
    public static final ParameterCodec INSTANCE = new ParameterCodec();
    private static final String ENCODED_CARET = "^^";
    private static final String ENCODED_NEWLINE = "^n";
    private static final String ENCODED_QUOTE = "^'";
    private static final Pattern CARET_EX = Pattern.compile("\\^");
    private static final Pattern NEWLINE_EX = Pattern.compile("\n");
    private static final Pattern QUOTE_EX = Pattern.compile("\"");
    private static final Pattern ENCODED_CARET_EX = Pattern.compile("^^".replaceAll("\\^", "\\\\^"));
    private static final Pattern ENCODED_NEWLINE_EX = Pattern.compile("^n".replaceAll("\\^", "\\\\^"));
    private static final Pattern ENCODED_QUOTE_EX = Pattern.compile("^'".replaceAll("\\^", "\\\\^"));
    public static final Pattern QUOTABLE_VALUE_EX = Pattern.compile("[:;,]|[^\\p{ASCII}]");
    public static final Pattern QUOTED_EX = Pattern.compile("^\"[^\"]*\"$");

    public String decode(String source) throws DecoderException {
        if (source != null) {
            String decoded = ENCODED_CARET_EX.matcher(ENCODED_NEWLINE_EX.matcher(ENCODED_QUOTE_EX.matcher(source).replaceAll("\"")).replaceAll("\n")).replaceAll("^");
            if (QUOTED_EX.matcher(decoded).matches()) {
                return decoded.substring(1, decoded.length() - 1);
            }
            return decoded;
        }
        throw new DecoderException("Input cannot be null");
    }

    public Object decode(Object source) throws DecoderException {
        if (source != null) {
            return this.decode(source.toString());
        }
        throw new DecoderException("Input cannot be null");
    }

    public String encode(String source) throws EncoderException {
        if (source != null) {
            String encoded = QUOTE_EX.matcher(NEWLINE_EX.matcher(CARET_EX.matcher(source).replaceAll(ENCODED_CARET)).replaceAll(ENCODED_NEWLINE)).replaceAll(ENCODED_QUOTE);
            if (QUOTABLE_VALUE_EX.matcher(encoded).find()) {
                return "\"" + encoded + "\"";
            }
            return encoded;
        }
        throw new EncoderException("Input cannot be null");
    }

    public Object encode(Object source) throws EncoderException {
        if (source != null) {
            return this.encode(source.toString());
        }
        throw new EncoderException("Input cannot be null");
    }
}

