/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fortuna.ical4j.model.ContentCollection;
import net.fortuna.ical4j.model.Parameter;
import org.jetbrains.annotations.NotNull;

public class ParameterList
implements ContentCollection<Parameter>,
Comparable<ParameterList> {
    private final List<Parameter> parameters;

    public ParameterList() {
        this(Collections.emptyList());
    }

    public ParameterList(@NotNull List<Parameter> list) {
        this.parameters = Collections.unmodifiableList(list);
    }

    @Override
    public ContentCollection<Parameter> add(Parameter content) {
        ArrayList<Parameter> copy = new ArrayList<Parameter>(this.parameters);
        copy.add(content);
        return new ParameterList(copy);
    }

    @Override
    public ContentCollection<Parameter> addAll(@NotNull Collection<Parameter> content) {
        ArrayList<Parameter> copy = new ArrayList<Parameter>(this.parameters);
        copy.addAll(content);
        return new ParameterList(copy);
    }

    @Override
    public ContentCollection<Parameter> remove(Parameter content) {
        ArrayList<Parameter> copy = new ArrayList<Parameter>(this.parameters);
        if (copy.remove(content)) {
            return new ParameterList(copy);
        }
        return this;
    }

    @Override
    public ContentCollection<Parameter> removeAll(String ... name) {
        List<String> names = Arrays.asList(name);
        return this.removeIf((Parameter p) -> names.contains(p.getName()));
    }

    @Override
    public ContentCollection<Parameter> removeIf(Predicate<Parameter> filter) {
        ArrayList<Parameter> copy = new ArrayList<Parameter>(this.parameters);
        if (copy.removeIf(filter)) {
            return new ParameterList(copy);
        }
        return this;
    }

    @Override
    public ContentCollection<Parameter> replace(@NotNull Parameter content) {
        ArrayList<Parameter> copy = new ArrayList<Parameter>(this.parameters);
        copy.removeIf((? super E p) -> p.getName().equals(content.getName()));
        copy.add(content);
        return new ParameterList(copy);
    }

    @Override
    public List<Parameter> getAll() {
        return this.parameters;
    }

    public final String toString() {
        if (!this.parameters.isEmpty()) {
            return this.parameters.stream().map(Parameter::toString).collect(Collectors.joining(";", ";", ""));
        }
        return "";
    }

    @Deprecated
    public final <T extends Parameter> Optional<T> getParameter(String aName) {
        return this.getFirst(aName);
    }

    @Deprecated
    public final ParameterList getParameters(String name) {
        return new ParameterList(this.get(name));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterList that = (ParameterList)o;
        return Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.parameters);
    }

    @Override
    public int compareTo(ParameterList o) {
        if (this.parameters.equals(o.parameters)) {
            return 0;
        }
        int retval = this.parameters.size() - o.parameters.size();
        if (retval != 0) {
            return retval;
        }
        return this.parameters.stream().filter(o.parameters::contains).mapToInt(p -> p.compareTo(o.parameters.get(o.parameters.indexOf(p)))).sum();
    }
}

