/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Objects;
import net.fortuna.ical4j.model.CalendarDateFormat;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.PeriodList;
import net.fortuna.ical4j.model.TemporalAdapter;
import net.fortuna.ical4j.model.TemporalAmountAdapter;
import net.fortuna.ical4j.model.TemporalAmountComparator;
import net.fortuna.ical4j.model.TemporalComparator;
import net.fortuna.ical4j.util.TimeZones;
import org.threeten.extra.Interval;

public class Period<T extends Temporal>
implements Comparable<Period<T>>,
Serializable {
    private static final TemporalComparator DATE_RANGE_COMPARATOR = TemporalComparator.INSTANCE;
    private final T start;
    private Component component;
    private final T end;
    private final TemporalAmountAdapter duration;
    private final transient CalendarDateFormat dateFormat;

    public Period(T start, T end) {
        this(start, end, CalendarDateFormat.from(start));
    }

    public Period(T start, T end, CalendarDateFormat dateFormat) {
        Objects.requireNonNull(start, "start");
        Objects.requireNonNull(end, "end");
        Objects.requireNonNull(dateFormat, "dateFormat");
        this.start = start;
        this.end = end;
        this.duration = null;
        this.dateFormat = dateFormat;
    }

    @Deprecated
    public Period(DateTime start, Dur duration) {
        this(TemporalAdapter.from(start).getTemporal(), TemporalAmountAdapter.from(duration));
    }

    public Period(T start, TemporalAmount duration) {
        this(start, new TemporalAmountAdapter(duration));
    }

    public Period(T start, TemporalAmount duration, CalendarDateFormat dateFormat) {
        this(start, new TemporalAmountAdapter(duration), dateFormat);
    }

    private Period(T start, TemporalAmountAdapter duration) {
        this(start, duration, CalendarDateFormat.from(start));
    }

    private Period(T start, TemporalAmountAdapter duration, CalendarDateFormat dateFormat) {
        Objects.requireNonNull(start, "start");
        Objects.requireNonNull(duration, "duration");
        Objects.requireNonNull(dateFormat, "dateFormat");
        this.start = start;
        this.duration = duration;
        this.end = start.plus(duration.getDuration());
        this.dateFormat = dateFormat;
    }

    public static <T extends Temporal> Period<T> parse(String value) {
        T start = Period.parseStartDate(value);
        T end = null;
        TemporalAmountAdapter duration = null;
        try {
            end = Period.parseEndDate(value, false);
        }
        catch (DateTimeParseException e) {
            duration = Period.parseDuration(value);
        }
        if (end != null) {
            return new Period<Object>(start, end, CalendarDateFormat.from(start));
        }
        return new Period<T>(start, duration, CalendarDateFormat.from(start));
    }

    private static <T extends Temporal> T parseStartDate(String value) throws DateTimeParseException {
        TemporalAdapter parsedValue = TemporalAdapter.parse(value.substring(0, value.indexOf(47)));
        return parsedValue.getTemporal();
    }

    private static <T extends Temporal> T parseEndDate(String value, boolean resolve) throws DateTimeParseException {
        Object end;
        try {
            end = TemporalAdapter.parse(value.substring(value.indexOf(47) + 1)).getTemporal();
        }
        catch (DateTimeParseException e) {
            if (resolve) {
                TemporalAmount duration = Period.parseDuration(value).getDuration();
                end = Period.parseStartDate(value).plus(duration);
            }
            throw e;
        }
        return end;
    }

    private static TemporalAmountAdapter parseDuration(String value) {
        String durationString = value.substring(value.indexOf(47) + 1);
        return TemporalAmountAdapter.parse(durationString);
    }

    public final TemporalAmount getDuration() {
        return Objects.requireNonNullElseGet(this.duration, () -> TemporalAmountAdapter.from(this.start, this.end)).getDuration();
    }

    public final T getEnd() {
        return this.end;
    }

    public final T getStart() {
        return this.start;
    }

    @Deprecated
    public final boolean includes(Date date, boolean inclusive) {
        return this.includes(date.toInstant());
    }

    public final boolean includes(Temporal date) {
        Objects.requireNonNull(date, "date");
        Instant dateInstant = date instanceof LocalDateTime ? ((LocalDateTime)date).toInstant(ZoneOffset.from(ZonedDateTime.now())) : Instant.from(date);
        return this.start.equals(date) || this.end.equals(date) || this.toInterval().encloses(Interval.of((Instant)dateInstant, (Duration)Duration.ZERO));
    }

    public final Period<T> add(Period<T> period) {
        T newPeriodEnd;
        T newPeriodStart;
        if (period == null) {
            newPeriodStart = this.getStart();
            newPeriodEnd = this.getEnd();
        } else {
            Interval thisInterval = TemporalAdapter.isFloating(this.getStart()) ? this.toInterval(TimeZones.getDefault().toZoneId()) : this.toInterval();
            Interval thatInterval = TemporalAdapter.isFloating(this.getStart()) ? period.toInterval(TimeZones.getDefault().toZoneId()) : period.toInterval();
            newPeriodStart = thisInterval.getStart().isBefore(thatInterval.getStart()) ? this.getStart() : period.getStart();
            newPeriodEnd = thisInterval.getEnd().isAfter(thatInterval.getEnd()) ? this.getEnd() : period.getEnd();
        }
        return new Period<T>(newPeriodStart, newPeriodEnd);
    }

    public final PeriodList<T> subtract(Period<T> period) {
        if (period.equals(this)) {
            return new PeriodList(this.dateFormat);
        }
        if (!period.intersects(this) || !TemporalAdapter.isDateTimePrecision(this.start)) {
            return new PeriodList(Collections.singletonList(this), this.dateFormat);
        }
        return this.subtractInterval(period);
    }

    private PeriodList<T> subtractInterval(Period<T> period) {
        T newPeriodEnd;
        T newPeriodStart;
        Interval thatInterval;
        Interval thisInterval = TemporalAdapter.isFloating(this.getStart()) ? this.toInterval(TimeZones.getDefault().toZoneId()) : this.toInterval();
        Interval interval = thatInterval = TemporalAdapter.isFloating(this.getStart()) ? period.toInterval(TimeZones.getDefault().toZoneId()) : period.toInterval();
        if (thatInterval.encloses(thisInterval)) {
            return new PeriodList(period.dateFormat);
        }
        if (!thatInterval.overlaps(thisInterval)) {
            return new PeriodList(Collections.singletonList(this));
        }
        ArrayList result = new ArrayList();
        if (!thatInterval.getStart().isAfter(thisInterval.getStart())) {
            newPeriodStart = period.getEnd();
            newPeriodEnd = this.getEnd();
        } else if (!thatInterval.getEnd().isBefore(thisInterval.getEnd())) {
            newPeriodStart = this.getStart();
            newPeriodEnd = period.getStart();
        } else {
            newPeriodStart = this.getStart();
            newPeriodEnd = period.getStart();
            result.add(new Period<T>(newPeriodStart, newPeriodEnd));
            newPeriodStart = period.getEnd();
            newPeriodEnd = this.getEnd();
        }
        result.add(new Period<T>(newPeriodStart, newPeriodEnd));
        return new PeriodList(result);
    }

    public final boolean isEmpty() {
        if (!TemporalAdapter.isDateTimePrecision(this.start)) {
            return this.start.equals(this.end);
        }
        return this.toInterval().isEmpty();
    }

    public String toString() {
        return this.toString(this.dateFormat);
    }

    String toString(CalendarDateFormat dateFormat) {
        StringBuilder b = new StringBuilder();
        b.append(dateFormat.format((TemporalAccessor)this.getStart()));
        b.append('/');
        if (this.duration == null) {
            b.append(dateFormat.format((TemporalAccessor)this.getEnd()));
        } else {
            b.append(this.duration);
        }
        return b.toString();
    }

    public String toString(ZoneId zoneId) {
        return this.toString(this.dateFormat, zoneId);
    }

    String toString(CalendarDateFormat dateFormat, ZoneId zoneId) {
        StringBuilder b = new StringBuilder();
        b.append(dateFormat.format((TemporalAccessor)this.getStart(), zoneId));
        b.append('/');
        if (this.duration == null) {
            b.append(dateFormat.format((TemporalAccessor)this.getEnd(), zoneId));
        } else {
            b.append(this.duration);
        }
        return b.toString();
    }

    public boolean intersects(Period<?> other) {
        Objects.requireNonNull(other, "other");
        Interval thisInterval = this.toInterval();
        Interval thatInterval = other.toInterval();
        return thisInterval.overlaps(thatInterval);
    }

    public Interval toInterval() {
        return this.toInterval(TimeZones.getDefault().toZoneId());
    }

    public Interval toInterval(ZoneId zoneId) {
        if (this.start instanceof LocalDate) {
            return Interval.of((Instant)((LocalDate)this.start).atStartOfDay(zoneId).toInstant(), (Instant)((LocalDate)this.end).atStartOfDay(zoneId).toInstant());
        }
        if (this.start instanceof Instant) {
            return Interval.of((Instant)((Instant)this.start), (Instant)((Instant)this.end));
        }
        ZoneOffset zoneOffset = zoneId.getRules().getOffset(Instant.now());
        if (this.duration != null) {
            return Interval.of((Instant)LocalDateTime.from(this.start).toInstant(zoneOffset), (Duration)this.duration.toDuration());
        }
        return Interval.of((Instant)LocalDateTime.from(this.start).toInstant(zoneOffset), (Instant)LocalDateTime.from(this.end).toInstant(zoneOffset));
    }

    @Override
    public final int compareTo(Period<T> period) {
        if (period == null) {
            throw new ClassCastException("Cannot compare this object to null");
        }
        return this.compareTo(period, DATE_RANGE_COMPARATOR);
    }

    private int compareTo(Period<T> period, TemporalComparator comparator) {
        int endCompare;
        int startCompare = comparator.compare((Temporal)this.getStart(), (Temporal)period.getStart());
        if (startCompare != 0) {
            return startCompare;
        }
        if (this.duration == null && (endCompare = comparator.compare((Temporal)this.getEnd(), (Temporal)period.getEnd())) != 0) {
            return endCompare;
        }
        return new TemporalAmountComparator().compare(this.getDuration(), period.getDuration());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Period period = (Period)o;
        return this.start.equals(period.start) && Objects.equals(this.end, period.end) && Objects.equals(this.duration, period.duration);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end, this.duration);
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
    }
}

