/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fortuna.ical4j.model.CalendarDateFormat;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.TemporalAdapter;
import org.threeten.extra.Interval;

public class PeriodList<T extends Temporal>
implements Serializable {
    private static final long serialVersionUID = -2317587285790834492L;
    private final Set<Period<T>> periods;
    private final transient CalendarDateFormat dateFormat;

    public PeriodList() {
        this(CalendarDateFormat.FLOATING_DATE_TIME_FORMAT);
    }

    public PeriodList(CalendarDateFormat dateFormat) {
        this(new TreeSet<Period<T>>(), dateFormat);
    }

    public PeriodList(Collection<Period<T>> periods) {
        this(periods, CalendarDateFormat.FLOATING_DATE_TIME_FORMAT);
    }

    public PeriodList(Collection<Period<T>> periods, CalendarDateFormat dateFormat) {
        Objects.requireNonNull(dateFormat, "dateFormat");
        this.periods = Collections.unmodifiableSet(new TreeSet<Period<T>>(periods));
        this.dateFormat = dateFormat;
    }

    public PeriodList(Interval[] intervals) {
        this(Arrays.stream(intervals).map(i -> new Period<Instant>(i.getStart(), i.getEnd())).collect(Collectors.toList()), CalendarDateFormat.UTC_DATE_TIME_FORMAT);
    }

    public static <T extends Temporal> PeriodList<T> parse(String aValue) {
        return PeriodList.parse(aValue, CalendarDateFormat.FLOATING_DATE_TIME_FORMAT);
    }

    public static <T extends Temporal> PeriodList<T> parse(String aValue, CalendarDateFormat calendarDateFormat) {
        return new PeriodList<T>(((Stream)Arrays.stream(aValue.split("\\s*,\\s*")).parallel()).map(Period::parse).collect(Collectors.toList()), calendarDateFormat);
    }

    public String toString() {
        return this.periods.stream().map(p -> p.toString(this.dateFormat)).collect(Collectors.joining(","));
    }

    public String toString(ZoneId zoneId) {
        return this.periods.stream().map(p -> p.toString(this.dateFormat, zoneId)).collect(Collectors.joining(","));
    }

    public final PeriodList<T> add(Period<T> period) {
        TreeSet<Period<T>> copy = new TreeSet<Period<T>>(this.periods);
        copy.add(period);
        return new PeriodList<T>(copy, this.dateFormat);
    }

    public final PeriodList<T> remove(Object period) {
        TreeSet<Period<T>> copy = new TreeSet<Period<T>>(this.periods);
        if (copy.remove(period)) {
            return new PeriodList<T>(copy, this.dateFormat);
        }
        return this;
    }

    public final PeriodList<T> normalise() {
        Period<T> prevPeriod = null;
        PeriodList<T> newList = new PeriodList<T>(this.dateFormat);
        boolean normalised = false;
        for (Period<T> period1 : this.periods) {
            Period<T> period = period1;
            if (!TemporalAdapter.isDateTimePrecision(period.getStart())) continue;
            if (period.isEmpty()) {
                period = prevPeriod;
                normalised = true;
            } else if (prevPeriod != null) {
                Interval periodInterval;
                Interval prevInterval = prevPeriod.toInterval();
                if (prevInterval.encloses(periodInterval = period.toInterval())) {
                    period = prevPeriod;
                    normalised = true;
                } else if (prevPeriod.intersects(period)) {
                    period = prevPeriod.add(period);
                    normalised = true;
                } else if (prevInterval.abuts(periodInterval)) {
                    period = prevPeriod.add(period);
                    normalised = true;
                } else {
                    newList = newList.add(prevPeriod);
                }
            }
            prevPeriod = period;
        }
        if (prevPeriod != null) {
            newList = newList.add(prevPeriod);
        }
        if (normalised) {
            return newList;
        }
        return this;
    }

    public final PeriodList<T> add(PeriodList<T> periods) {
        if (periods != null) {
            PeriodList<T> newList = new PeriodList<T>(this.periods, this.dateFormat);
            return newList.addAll(periods.periods).normalise();
        }
        return this;
    }

    public final PeriodList<T> subtract(PeriodList<T> subtractions) {
        if (subtractions == null || subtractions.periods.isEmpty()) {
            return this;
        }
        PeriodList<T> result = this;
        PeriodList<T> tmpResult = new PeriodList<T>(this.dateFormat);
        for (Period subtraction : subtractions.getPeriods()) {
            if (!TemporalAdapter.isDateTimePrecision(subtraction.getStart())) {
                tmpResult = tmpResult.addAll(result.getPeriods().stream().filter(p -> !p.equals(subtraction)).collect(Collectors.toList()));
            } else {
                for (Period<T> period : result.getPeriods()) {
                    tmpResult = tmpResult.addAll(period.subtract(subtraction).getPeriods());
                }
            }
            result = tmpResult;
            tmpResult = new PeriodList<T>(this.dateFormat);
        }
        return result;
    }

    public Set<Period<T>> getPeriods() {
        return this.periods;
    }

    public PeriodList<T> addAll(Collection<Period<T>> arg0) {
        TreeSet<Period<T>> copy = new TreeSet<Period<T>>(this.periods);
        copy.addAll(arg0);
        return new PeriodList<T>(copy, this.dateFormat);
    }

    public List<Interval> toIntervalList() {
        return this.periods.stream().map(Period::toInterval).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PeriodList that = (PeriodList)o;
        return Objects.equals(this.periods, that.periods) && this.dateFormat.equals(that.dateFormat);
    }

    public int hashCode() {
        return Objects.hash(this.periods, this.dateFormat);
    }
}

