/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Encodable;
import net.fortuna.ical4j.model.FluentProperty;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.PropertyCodec;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.model.Prototype;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.XProperty;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jetbrains.annotations.NotNull;

public abstract class Property
extends Content
implements Prototype<Property>,
Comparable<Property>,
FluentProperty {
    private static final long serialVersionUID = 7048785558435608687L;
    public static final String PRODID = "PRODID";
    public static final String VERSION = "VERSION";
    public static final String CALSCALE = "CALSCALE";
    public static final String METHOD = "METHOD";
    public static final String BUSYTYPE = "BUSYTYPE";
    public static final String CLASS = "CLASS";
    public static final String CREATED = "CREATED";
    public static final String DESCRIPTION = "DESCRIPTION";
    public static final String DTSTART = "DTSTART";
    public static final String GEO = "GEO";
    public static final String LAST_MODIFIED = "LAST-MODIFIED";
    public static final String LOCATION = "LOCATION";
    public static final String ORGANIZER = "ORGANIZER";
    public static final String PERCENT_COMPLETE = "PERCENT-COMPLETE";
    public static final String PRIORITY = "PRIORITY";
    public static final String DTSTAMP = "DTSTAMP";
    public static final String SEQUENCE = "SEQUENCE";
    public static final String STATUS = "STATUS";
    public static final String SUMMARY = "SUMMARY";
    public static final String TRANSP = "TRANSP";
    public static final String UID = "UID";
    public static final String URL = "URL";
    public static final String RECURRENCE_ID = "RECURRENCE-ID";
    public static final String COMPLETED = "COMPLETED";
    public static final String DUE = "DUE";
    public static final String FREEBUSY = "FREEBUSY";
    public static final String TZID = "TZID";
    public static final String TZNAME = "TZNAME";
    public static final String TZOFFSETFROM = "TZOFFSETFROM";
    public static final String TZOFFSETTO = "TZOFFSETTO";
    public static final String TZURL = "TZURL";
    public static final String ACTION = "ACTION";
    public static final String REPEAT = "REPEAT";
    public static final String TRIGGER = "TRIGGER";
    public static final String REQUEST_STATUS = "REQUEST-STATUS";
    public static final String DTEND = "DTEND";
    public static final String DURATION = "DURATION";
    public static final String ATTACH = "ATTACH";
    public static final String ATTENDEE = "ATTENDEE";
    public static final String CATEGORIES = "CATEGORIES";
    public static final String COMMENT = "COMMENT";
    public static final String CONTACT = "CONTACT";
    public static final String EXDATE = "EXDATE";
    public static final String EXRULE = "EXRULE";
    public static final String RELATED_TO = "RELATED-TO";
    public static final String RESOURCE_TYPE = "RESOURCE-TYPE";
    public static final String RESOURCES = "RESOURCES";
    public static final String RDATE = "RDATE";
    public static final String RRULE = "RRULE";
    public static final String EXPERIMENTAL_PREFIX = "X-";
    public static final String COUNTRY = "COUNTRY";
    public static final String EXTENDED_ADDRESS = "EXTENDED-ADDRESS";
    public static final String LOCALITY = "LOCALITY";
    public static final String NAME = "NAME";
    public static final String POSTALCODE = "POSTAL-CODE";
    public static final String REGION = "REGION";
    public static final String STREET_ADDRESS = "STREET-ADDRESS";
    public static final String TEL = "TEL";
    public static final String ACKNOWLEDGED = "ACKNOWLEDGED";
    public static final String PROXIMITY = "PROXIMITY";
    public static final String CALENDAR_ADDRESS = "CALENDAR-ADDRESS";
    public static final String LOCATION_TYPE = "LOCATION-TYPE";
    public static final String PARTICIPANT_TYPE = "PARTICIPANT-TYPE";
    public static final String STRUCTURED_DATA = "STRUCTURED-DATA";
    public static final String STYLED_DESCRIPTION = "STYLED-DESCRIPTION";
    public static final String TZUNTIL = "TZUNTIL";
    public static final String TZID_ALIAS_OF = "TZID-ALIAS-OF";
    public static final String XML = "XML";
    private final String name;
    private String prefix;
    private ParameterList parameters;

    protected Property(String aName) {
        this(aName, new ParameterList());
    }

    protected Property(@NotNull Enum<?> name) {
        this(name.toString(), new ParameterList());
    }

    protected Property(String aName, ParameterList aList) {
        this.name = aName;
        this.parameters = aList;
    }

    protected Property(@NotNull Enum<?> name, ParameterList aList) {
        this.name = name.toString();
        this.parameters = aList;
    }

    public String toString() {
        String value;
        StringBuilder buffer = new StringBuilder();
        if (this.prefix != null && !this.prefix.isEmpty()) {
            buffer.append(this.prefix);
            buffer.append('.');
        }
        buffer.append(this.getName());
        if (this.parameters != null) {
            buffer.append(this.parameters);
        }
        buffer.append(':');
        if (this instanceof XProperty && this.getParameter("VALUE").isPresent() && !Value.TEXT.equals(this.getRequiredParameter("VALUE"))) {
            value = this.getValue();
        } else if (this instanceof Encodable) {
            try {
                value = PropertyCodec.INSTANCE.encode(this.getValue());
            }
            catch (EncoderException e) {
                value = this.getValue();
            }
        } else {
            value = this.getValue();
        }
        buffer.append(Strings.valueOf(value));
        buffer.append("\r\n");
        return buffer.toString();
    }

    @Override
    public Property getFluentTarget() {
        return this;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public final ParameterList getParameterList() {
        return this.parameters;
    }

    protected void setParameters(ParameterList parameters) {
        this.parameters = parameters;
    }

    public <T extends Property> T add(Parameter parameter) {
        this.setParameters((ParameterList)this.parameters.add(parameter));
        return (T)this;
    }

    public <T extends Property> T remove(Parameter parameter) {
        this.setParameters((ParameterList)this.parameters.remove(parameter));
        return (T)this;
    }

    public <T extends Property> T removeAll(String ... parameterName) {
        this.setParameters((ParameterList)this.parameters.removeAll(parameterName));
        return (T)this;
    }

    public <T extends Property> T replace(Parameter parameter) {
        this.setParameters((ParameterList)this.parameters.replace(parameter));
        return (T)this;
    }

    public final List<Parameter> getParameters(String ... name) {
        return this.parameters.get(name);
    }

    public final <P extends Parameter> Optional<P> getParameter(String name) {
        return this.parameters.getFirst(name);
    }

    public final <P extends Parameter> Optional<P> getParameter(@NotNull Enum<?> name) {
        return this.getParameter(name.toString());
    }

    public final <P extends Parameter> P getRequiredParameter(String name) {
        return (P)((Parameter)this.parameters.getRequired(name));
    }

    public final <P extends Parameter> P getRequiredParameter(@NotNull Enum<?> name) {
        return this.getRequiredParameter(name.toString());
    }

    public abstract void setValue(String var1);

    public abstract ValidationResult validate() throws ValidationException;

    public boolean equals(Object arg0) {
        if (arg0 instanceof Property) {
            Property p = (Property)arg0;
            return this.getName().equals(p.getName()) && new EqualsBuilder().append((Object)this.getValue(), (Object)p.getValue()).append((Object)this.parameters, (Object)p.parameters).append((Object)this.prefix, (Object)p.prefix).isEquals();
        }
        return super.equals(arg0);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getName().toUpperCase()).append((Object)this.getValue()).append((Object)this.parameters).append((Object)this.getPrefix()).toHashCode();
    }

    protected abstract PropertyFactory<?> newFactory();

    @Override
    public final Property copy() {
        if (this.getName().toUpperCase().startsWith(EXPERIMENTAL_PREFIX)) {
            return new XProperty(this.getName(), new ParameterList(this.getParameters(new String[0])), this.getValue());
        }
        return this.newFactory().createProperty(this.parameters, this.getValue());
    }

    @Override
    public int compareTo(Property o) {
        if (this.equals(o)) {
            return 0;
        }
        return Comparator.comparing(Property::getName).thenComparing(Content::getValue).thenComparing(Property::getParameterList).thenComparing(Property::getPrefix, Comparator.nullsFirst(Comparator.naturalOrder())).compare(this, o);
    }
}

