/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.fortuna.ical4j.model.AbstractContentBuilder;
import net.fortuna.ical4j.model.Encodable;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyCodec;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.property.DateListProperty;
import net.fortuna.ical4j.model.property.DateProperty;
import net.fortuna.ical4j.model.property.UtcProperty;
import net.fortuna.ical4j.model.property.XProperty;
import net.fortuna.ical4j.util.CompatibilityHints;
import org.apache.commons.codec.DecoderException;

public class PropertyBuilder
extends AbstractContentBuilder {
    private final List<PropertyFactory<?>> factories;
    private String name;
    private String prefix;
    private String value;
    private final List<Parameter> parameters = new ArrayList<Parameter>();
    private TimeZoneRegistry timeZoneRegistry;
    private ZoneId defaultTimeZone;

    public PropertyBuilder() {
        this(new ArrayList<PropertyFactory<? extends Property>>());
    }

    public PropertyBuilder(List<PropertyFactory<? extends Property>> factories) {
        this.factories = factories;
    }

    @Deprecated
    public PropertyBuilder factories(List<PropertyFactory<?>> factories) {
        this.factories.clear();
        this.factories.addAll(factories);
        return this;
    }

    public PropertyBuilder name(String name) {
        String[] nameParts = name.split("\\.");
        if (nameParts.length > 1) {
            this.prefix = String.join((CharSequence)".", Arrays.copyOfRange(nameParts, 0, nameParts.length - 1));
            this.name = nameParts[nameParts.length - 1];
        } else {
            this.name = name;
        }
        return this;
    }

    public boolean hasName(String name) {
        return name.equalsIgnoreCase(this.name);
    }

    public PropertyBuilder value(String value) {
        this.value = value.trim();
        return this;
    }

    public PropertyBuilder parameter(Parameter parameter) {
        this.parameters.add(parameter);
        return this;
    }

    public PropertyBuilder timeZoneRegistry(TimeZoneRegistry timeZoneRegistry) {
        this.timeZoneRegistry = timeZoneRegistry;
        return this;
    }

    public PropertyBuilder defaultTimeZone(ZoneId defaultTimeZone) {
        this.defaultTimeZone = defaultTimeZone;
        return this;
    }

    public Property build() {
        String decodedValue;
        if (CompatibilityHints.isHintEnabled("ical4j.parsing.relaxed")) {
            this.parameters.removeIf(p -> "UTC".equals(p.getValue()));
        }
        Property property = null;
        try {
            decodedValue = PropertyCodec.INSTANCE.decode(this.value);
        }
        catch (DecoderException e) {
            decodedValue = this.value;
        }
        for (PropertyFactory<?> factory : this.factories) {
            if (!factory.supports(this.name)) continue;
            property = factory.createProperty(new ParameterList(this.parameters), this.value);
            if (property instanceof DateProperty) {
                DateProperty dateProp = (DateProperty)property;
                if (dateProp instanceof UtcProperty) break;
                dateProp.setTimeZoneRegistry(this.timeZoneRegistry);
                dateProp.setDefaultTimeZone(this.defaultTimeZone);
                property.setValue(this.value);
                break;
            }
            if (!(property instanceof DateListProperty)) break;
            DateListProperty dateListProperty = (DateListProperty)property;
            dateListProperty.setTimeZoneRegistry(this.timeZoneRegistry);
            dateListProperty.setDefaultTimeZone(this.defaultTimeZone);
            property.setValue(this.value);
            break;
        }
        if (property == null) {
            if (this.isExperimentalName(this.name)) {
                property = new XProperty(this.name, new ParameterList(this.parameters), this.value);
            } else if (this.allowIllegalNames()) {
                property = new XProperty(this.name, new ParameterList(this.parameters), this.value);
            } else {
                throw new IllegalArgumentException("Illegal property [" + this.name + "]");
            }
        }
        if (property instanceof Encodable) {
            property.setValue(decodedValue);
        }
        if (this.prefix != null) {
            property.setPrefix(this.prefix);
        }
        return property;
    }
}

