/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.util.regex.Pattern;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringDecoder;
import org.apache.commons.codec.StringEncoder;

public class PropertyCodec
implements StringEncoder,
StringDecoder {
    public static final PropertyCodec INSTANCE = new PropertyCodec();
    private static final String ENCODED_NEWLINE = "\\\\n";
    private static final String ENCODED_BACKSLASH = "\\\\\\\\";
    private static final Pattern BACKSLASH_EX = Pattern.compile("\\\\");
    private static final Pattern NEWLINE_EX = Pattern.compile("\r?\n");
    private static final Pattern SPECIALCHAR_EX = Pattern.compile("([,;])");
    private static final Pattern ENCODED_BACKSLASH_EX = Pattern.compile("\\\\\\\\");
    private static final Pattern ENCODED_NEWLINE_EX = Pattern.compile("(?<!\\\\)\\\\n");
    private static final Pattern ENCODED_SPECIALCHAR_EX = Pattern.compile("\\\\([,;\"])");

    public String decode(String source) throws DecoderException {
        if (source != null) {
            return ENCODED_BACKSLASH_EX.matcher(ENCODED_NEWLINE_EX.matcher(ENCODED_SPECIALCHAR_EX.matcher(source).replaceAll("$1")).replaceAll("\n")).replaceAll("\\\\");
        }
        throw new DecoderException("Input cannot be null");
    }

    public Object decode(Object source) throws DecoderException {
        if (source != null) {
            return this.decode(source.toString());
        }
        throw new DecoderException("Input cannot be null");
    }

    public String encode(String source) throws EncoderException {
        if (source != null) {
            return SPECIALCHAR_EX.matcher(NEWLINE_EX.matcher(BACKSLASH_EX.matcher(source).replaceAll(ENCODED_BACKSLASH)).replaceAll(ENCODED_NEWLINE)).replaceAll("\\\\$1");
        }
        throw new EncoderException("Input cannot be null");
    }

    public Object encode(Object source) throws EncoderException {
        if (source != null) {
            return this.encode(source.toString());
        }
        throw new EncoderException("Input cannot be null");
    }
}

