/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fortuna.ical4j.model.ContentCollection;
import net.fortuna.ical4j.model.Property;
import org.jetbrains.annotations.NotNull;

public class PropertyList
implements ContentCollection<Property>,
Comparable<PropertyList> {
    private final List<Property> properties;

    public PropertyList() {
        this(Collections.emptyList());
    }

    public PropertyList(@NotNull List<Property> properties) {
        this.properties = Collections.unmodifiableList(properties);
    }

    @Override
    public ContentCollection<Property> add(@NotNull Property content) {
        ArrayList<Property> copy = new ArrayList<Property>(this.properties);
        copy.add(content);
        return new PropertyList(copy);
    }

    @Override
    public ContentCollection<Property> addAll(@NotNull Collection<Property> content) {
        ArrayList<Property> copy = new ArrayList<Property>(this.properties);
        copy.addAll(content);
        return new PropertyList(copy);
    }

    @Override
    public ContentCollection<Property> remove(Property content) {
        ArrayList<Property> copy = new ArrayList<Property>(this.properties);
        if (copy.remove(content)) {
            return new PropertyList(copy);
        }
        return this;
    }

    @Override
    public ContentCollection<Property> removeAll(String ... name) {
        List<String> names = Arrays.asList(name);
        return this.removeIf((Property p) -> names.contains(p.getName()));
    }

    @Override
    public ContentCollection<Property> removeIf(Predicate<Property> filter) {
        ArrayList<Property> copy = new ArrayList<Property>(this.properties);
        if (copy.removeIf(filter)) {
            return new PropertyList(copy);
        }
        return this;
    }

    @Override
    public ContentCollection<Property> replace(@NotNull Property content) {
        ArrayList<Property> copy = new ArrayList<Property>(this.properties);
        copy.removeIf((? super E p) -> p.getName().equals(content.getName()));
        copy.add(content);
        return new PropertyList(copy);
    }

    @Override
    public List<Property> getAll() {
        return this.properties;
    }

    public final String toString() {
        return this.properties.stream().map(Property::toString).collect(Collectors.joining(""));
    }

    @Deprecated
    public final <T extends Property> Optional<T> getProperty(String aName) {
        return this.getFirst(aName);
    }

    @Deprecated
    public final List<Property> getProperties(String name) {
        return this.get(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyList that = (PropertyList)o;
        return Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.properties);
    }

    @Override
    public int compareTo(PropertyList o) {
        if (this.properties.equals(o.properties)) {
            return 0;
        }
        int retval = this.properties.size() - o.properties.size();
        if (retval != 0) {
            return retval;
        }
        return this.properties.stream().filter(o.properties::contains).mapToInt(p -> p.compareTo(o.properties.get(o.properties.indexOf(p)))).sum();
    }
}

