/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.chrono.Chronology;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.fortuna.ical4j.model.Month;
import net.fortuna.ical4j.model.MonthList;
import net.fortuna.ical4j.model.NumberList;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.TemporalAdapter;
import net.fortuna.ical4j.model.TemporalComparator;
import net.fortuna.ical4j.model.WeekDay;
import net.fortuna.ical4j.model.WeekDayList;
import net.fortuna.ical4j.transform.recurrence.ByDayRule;
import net.fortuna.ical4j.transform.recurrence.ByHourRule;
import net.fortuna.ical4j.transform.recurrence.ByMinuteRule;
import net.fortuna.ical4j.transform.recurrence.ByMonthDayRule;
import net.fortuna.ical4j.transform.recurrence.ByMonthRule;
import net.fortuna.ical4j.transform.recurrence.BySecondRule;
import net.fortuna.ical4j.transform.recurrence.BySetPosRule;
import net.fortuna.ical4j.transform.recurrence.ByWeekNoRule;
import net.fortuna.ical4j.transform.recurrence.ByYearDayRule;
import net.fortuna.ical4j.transform.recurrence.Frequency;
import net.fortuna.ical4j.util.CompatibilityHints;
import net.fortuna.ical4j.util.Configurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Recur<T extends Temporal>
implements Serializable {
    private static final long serialVersionUID = -7333226591784095142L;
    private static final String FREQ = "FREQ";
    private static final String UNTIL = "UNTIL";
    private static final String COUNT = "COUNT";
    private static final String INTERVAL = "INTERVAL";
    private static final String BYSECOND = "BYSECOND";
    private static final String BYMINUTE = "BYMINUTE";
    private static final String BYHOUR = "BYHOUR";
    private static final String BYDAY = "BYDAY";
    private static final String BYMONTHDAY = "BYMONTHDAY";
    private static final String BYYEARDAY = "BYYEARDAY";
    private static final String BYWEEKNO = "BYWEEKNO";
    private static final String BYMONTH = "BYMONTH";
    private static final String BYSETPOS = "BYSETPOS";
    private static final String WKST = "WKST";
    private static final String RSCALE = "RSCALE";
    private static final String SKIP = "SKIP";
    @Deprecated
    public static final String SECONDLY = "SECONDLY";
    @Deprecated
    public static final String MINUTELY = "MINUTELY";
    @Deprecated
    public static final String HOURLY = "HOURLY";
    @Deprecated
    public static final String DAILY = "DAILY";
    @Deprecated
    public static final String WEEKLY = "WEEKLY";
    @Deprecated
    public static final String MONTHLY = "MONTHLY";
    @Deprecated
    public static final String YEARLY = "YEARLY";
    public static final String KEY_MAX_INCREMENT_COUNT = "net.fortuna.ical4j.recur.maxincrementcount";
    private static final int maxIncrementCount = Configurator.getIntProperty("net.fortuna.ical4j.recur.maxincrementcount").orElse(1000);
    private transient Logger log = LoggerFactory.getLogger(Recur.class);
    private static final Comparator<Temporal> CANDIDATE_SORTER = TemporalComparator.INSTANCE;
    private Frequency frequency;
    private Skip skip;
    private TemporalAdapter<T> until;
    private RScale rscale;
    private Integer count;
    private Integer interval;
    private List<Integer> secondList = new NumberList(ChronoField.SECOND_OF_MINUTE.range(), false);
    private List<Integer> minuteList = new NumberList(ChronoField.MINUTE_OF_HOUR.range(), false);
    private List<Integer> hourList = new NumberList(ChronoField.HOUR_OF_DAY.range(), false);
    private final List<WeekDay> dayList = new WeekDayList();
    private List<Integer> monthDayList = new NumberList(ChronoField.DAY_OF_MONTH.range(), true);
    private List<Integer> yearDayList = new NumberList(ChronoField.DAY_OF_YEAR.range(), true);
    private List<Integer> weekNoList = new NumberList(WeekFields.ISO.weekOfWeekBasedYear().range(), true);
    private List<Month> monthList = new MonthList(ChronoField.MONTH_OF_YEAR.range());
    private List<Integer> setPosList = new NumberList(ChronoField.DAY_OF_YEAR.range(), true);
    private WeekDay weekStartDay;
    private final Map<String, String> experimentalValues = new HashMap<String, String>();
    private TemporalUnit calIncField;

    private Recur() {
    }

    public Recur(String aValue) {
        this(aValue, CompatibilityHints.isHintEnabled("ical4j.parsing.relaxed"));
    }

    public Recur(String aValue, boolean experimentalTokensAllowed) {
        Chronology chronology = Chronology.ofLocale(Locale.getDefault());
        Iterator<String> tokens = Arrays.asList(aValue.split("[;=]")).iterator();
        while (tokens.hasNext()) {
            String token = tokens.next();
            if (FREQ.equals(token)) {
                this.frequency = Frequency.valueOf(this.nextToken(tokens, token));
                continue;
            }
            if (SKIP.equals(token)) {
                this.skip = Skip.valueOf(this.nextToken(tokens, token));
                continue;
            }
            if (RSCALE.equals(token)) {
                this.rscale = RScale.valueOf(this.nextToken(tokens, token));
                chronology = Chronology.of(this.rscale.getChronology());
                continue;
            }
            if (UNTIL.equals(token)) {
                String untilString = this.nextToken(tokens, token);
                this.until = TemporalAdapter.parse(untilString);
                continue;
            }
            if (COUNT.equals(token)) {
                this.count = Integer.parseInt(this.nextToken(tokens, token));
                continue;
            }
            if (INTERVAL.equals(token)) {
                this.interval = Integer.parseInt(this.nextToken(tokens, token));
                continue;
            }
            if (BYSECOND.equals(token)) {
                this.secondList = new NumberList(this.nextToken(tokens, token), chronology.range(ChronoField.SECOND_OF_MINUTE), false);
                continue;
            }
            if (BYMINUTE.equals(token)) {
                this.minuteList = new NumberList(this.nextToken(tokens, token), chronology.range(ChronoField.MINUTE_OF_HOUR), false);
                continue;
            }
            if (BYHOUR.equals(token)) {
                this.hourList = new NumberList(this.nextToken(tokens, token), chronology.range(ChronoField.HOUR_OF_DAY), false);
                continue;
            }
            if (BYDAY.equals(token)) {
                this.dayList.addAll(new WeekDayList(this.nextToken(tokens, token)));
                continue;
            }
            if (BYMONTHDAY.equals(token)) {
                this.monthDayList = new NumberList(this.nextToken(tokens, token), chronology.range(ChronoField.DAY_OF_MONTH), true);
                continue;
            }
            if (BYYEARDAY.equals(token)) {
                this.yearDayList = new NumberList(this.nextToken(tokens, token), chronology.range(ChronoField.DAY_OF_YEAR), true);
                continue;
            }
            if (BYWEEKNO.equals(token)) {
                this.weekNoList = new NumberList(this.nextToken(tokens, token), chronology.range(ChronoField.ALIGNED_WEEK_OF_YEAR), true);
                continue;
            }
            if (BYMONTH.equals(token)) {
                this.monthList = new MonthList(this.nextToken(tokens, token), chronology.range(ChronoField.MONTH_OF_YEAR));
                continue;
            }
            if (BYSETPOS.equals(token)) {
                this.setPosList = new NumberList(this.nextToken(tokens, token), chronology.range(ChronoField.DAY_OF_YEAR), true);
                continue;
            }
            if (WKST.equals(token)) {
                this.weekStartDay = WeekDay.getWeekDay(WeekDay.Day.valueOf(this.nextToken(tokens, token)));
                continue;
            }
            if (experimentalTokensAllowed) {
                this.experimentalValues.put(token, this.nextToken(tokens, token));
                continue;
            }
            throw new IllegalArgumentException(String.format("Invalid recurrence rule part: %s=%s", token, this.nextToken(tokens, token)));
        }
        this.validateFrequency();
    }

    private String nextToken(Iterator<String> tokens, String lastToken) {
        try {
            return tokens.next();
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("Missing expected token, last token: " + lastToken);
        }
    }

    @Deprecated
    public Recur(String frequency, T until) {
        this(Frequency.valueOf(frequency), until);
    }

    public Recur(Frequency frequency) {
        this.frequency = frequency;
        this.validateFrequency();
    }

    public Recur(Frequency frequency, T until) {
        this.frequency = frequency;
        this.until = new TemporalAdapter<T>(until);
        this.validateFrequency();
    }

    @Deprecated
    public Recur(String frequency, int count) {
        this(Frequency.valueOf(frequency), count);
    }

    public Recur(Frequency frequency, int count) {
        this.frequency = frequency;
        this.count = count;
        this.validateFrequency();
    }

    private Frequency deriveFilterType() {
        if (this.frequency == Frequency.DAILY || !this.getYearDayList().isEmpty() || !this.getMonthDayList().isEmpty()) {
            return Frequency.DAILY;
        }
        if (this.frequency == Frequency.WEEKLY || !this.getWeekNoList().isEmpty()) {
            return Frequency.WEEKLY;
        }
        if (this.frequency == Frequency.MONTHLY || !this.getMonthList().isEmpty()) {
            return Frequency.MONTHLY;
        }
        return this.frequency;
    }

    public final List<WeekDay> getDayList() {
        return this.dayList;
    }

    public final List<Integer> getHourList() {
        return this.hourList;
    }

    public final List<Integer> getMinuteList() {
        return this.minuteList;
    }

    public final List<Integer> getMonthDayList() {
        return this.monthDayList;
    }

    public final List<Month> getMonthList() {
        return this.monthList;
    }

    public final List<Integer> getSecondList() {
        return this.secondList;
    }

    public final List<Integer> getSetPosList() {
        return this.setPosList;
    }

    public final List<Integer> getWeekNoList() {
        return this.weekNoList;
    }

    public final List<Integer> getYearDayList() {
        return this.yearDayList;
    }

    public final int getCount() {
        return Optional.ofNullable(this.count).orElse(-1);
    }

    public final Map<String, String> getExperimentalValues() {
        return this.experimentalValues;
    }

    public final Frequency getFrequency() {
        return this.frequency;
    }

    public Skip getSkip() {
        return this.skip;
    }

    public final int getInterval() {
        return Optional.ofNullable(this.interval).orElse(-1);
    }

    public final T getUntil() {
        return this.until != null ? (T)this.until.getTemporal() : null;
    }

    public final WeekDay getWeekStartDay() {
        return this.weekStartDay;
    }

    @Deprecated
    public final void setWeekStartDay(WeekDay weekStartDay) {
        this.weekStartDay = weekStartDay;
        if (this.frequency != null) {
            this.validateFrequency();
        }
    }

    public final String toString() {
        StringBuilder b = new StringBuilder();
        if (this.rscale != null) {
            b.append(RSCALE).append('=').append((Object)this.rscale).append(';');
        }
        b.append(FREQ).append('=').append((Object)this.frequency);
        if (this.weekStartDay != null) {
            b.append(';').append(WKST).append('=').append(this.weekStartDay);
        }
        if (this.until != null) {
            b.append(';').append(UNTIL).append('=').append(this.until);
        }
        if (this.count != null) {
            b.append(';').append(COUNT).append('=').append(this.count);
        }
        if (this.interval != null) {
            b.append(';').append(INTERVAL).append('=').append(this.interval);
        }
        if (!this.monthList.isEmpty()) {
            b.append(';').append(BYMONTH).append('=').append(this.monthList);
        }
        if (!this.weekNoList.isEmpty()) {
            b.append(';').append(BYWEEKNO).append('=').append(NumberList.toString(this.weekNoList));
        }
        if (!this.yearDayList.isEmpty()) {
            b.append(';').append(BYYEARDAY).append('=').append(NumberList.toString(this.yearDayList));
        }
        if (!this.monthDayList.isEmpty()) {
            b.append(';').append(BYMONTHDAY).append('=').append(NumberList.toString(this.monthDayList));
        }
        if (!this.dayList.isEmpty()) {
            b.append(';').append(BYDAY).append('=').append(WeekDayList.toString(this.dayList));
        }
        if (!this.hourList.isEmpty()) {
            b.append(';').append(BYHOUR).append('=').append(NumberList.toString(this.hourList));
        }
        if (!this.minuteList.isEmpty()) {
            b.append(';').append(BYMINUTE).append('=').append(NumberList.toString(this.minuteList));
        }
        if (!this.secondList.isEmpty()) {
            b.append(';').append(BYSECOND).append('=').append(NumberList.toString(this.secondList));
        }
        if (!this.setPosList.isEmpty()) {
            b.append(';').append(BYSETPOS).append('=').append(NumberList.toString(this.setPosList));
        }
        if (this.skip != null) {
            b.append(';').append(SKIP).append('=').append((Object)this.skip);
        }
        return b.toString();
    }

    public final List<T> getDates(T periodStart, T periodEnd) {
        return this.getDates(periodStart, (Temporal)periodStart, (Temporal)periodEnd, -1);
    }

    public final List<T> getDates(T seed, Period<? extends Temporal> period) {
        return this.getDates(seed, period.getStart(), period.getEnd(), -1);
    }

    public final List<T> getDates(T seed, Temporal periodStart, Temporal periodEnd) {
        return this.getDates(seed, periodStart, periodEnd, -1);
    }

    public final List<T> getDates(T seed, Temporal periodStart, Temporal periodEnd, int maxCount) {
        List dates = this.getDatesAsStream(seed, periodStart, periodEnd, maxCount).collect(Collectors.toList());
        if (!TemporalAdapter.isDateTimePrecision(seed)) {
            dates.sort(new TemporalComparator(ChronoUnit.DAYS));
        } else {
            dates.sort(CANDIDATE_SORTER);
        }
        return dates;
    }

    public final Stream<T> getDatesAsStream(T seed, Temporal periodStart, Temporal periodEnd, int maxCount) {
        DateSpliterator spliterator = new DateSpliterator(this, seed, periodStart, periodEnd, maxCount);
        return StreamSupport.stream(spliterator, false);
    }

    public final T getNextDate(T seed, T startDate) {
        T candidateSeed = seed;
        if (this.count == null) {
            while (TemporalAdapter.isBefore(candidateSeed, startDate)) {
                candidateSeed = this.increment(candidateSeed);
            }
        }
        int invalidCandidateCount = 0;
        int noCandidateIncrementCount = 0;
        Object candidate = candidateSeed;
        while (!(this.getUntil() != null && TemporalAdapter.isAfter(candidate, this.getUntil()) || this.getCount() > 0 && invalidCandidateCount >= this.getCount())) {
            List<T> candidates = this.getCandidates(seed, candidateSeed);
            if (!candidates.isEmpty()) {
                noCandidateIncrementCount = 0;
                for (Temporal candidate1 : candidates) {
                    candidate = candidate1;
                    if (TemporalAdapter.isBefore(candidate, seed)) continue;
                    if (!TemporalAdapter.isAfter(candidate, startDate)) {
                        ++invalidCandidateCount;
                        continue;
                    }
                    if (this.getCount() <= 0 || invalidCandidateCount < this.getCount()) {
                        if (this.getUntil() != null && TemporalAdapter.isAfter(candidate, this.getUntil())) continue;
                        return candidate;
                    }
                    break;
                }
            } else if (maxIncrementCount > 0 && ++noCandidateIncrementCount > maxIncrementCount) break;
            candidateSeed = this.increment(candidateSeed);
        }
        return null;
    }

    private T increment(T cal) {
        int calInterval = Math.max(this.getInterval(), 1);
        return (T)cal.plus(calInterval, this.calIncField);
    }

    private List<T> getCandidates(T rootSeed, T date) {
        List<T> dates = new ArrayList<T>();
        dates.add(date);
        if (!this.monthList.isEmpty()) {
            dates = new ByMonthRule<T>(this.monthList, this.frequency, this.skip).apply(dates);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Dates after BYMONTH processing: " + dates);
            }
        }
        if (!this.weekNoList.isEmpty()) {
            dates = new ByWeekNoRule<T>(this.weekNoList, this.frequency, WeekDay.getDayOfWeek(this.weekStartDay)).apply(dates);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Dates after BYWEEKNO processing: " + dates);
            }
        }
        if (!this.yearDayList.isEmpty()) {
            dates = new ByYearDayRule<T>(this.yearDayList, this.frequency).apply(dates);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Dates after BYYEARDAY processing: " + dates);
            }
        }
        if (!this.monthDayList.isEmpty()) {
            dates = new ByMonthDayRule<T>(this.monthDayList, this.frequency, this.skip).apply(dates);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Dates after BYMONTHDAY processing: " + dates);
            }
        } else if (this.frequency == Frequency.MONTHLY || this.frequency == Frequency.YEARLY && this.yearDayList.isEmpty() && this.weekNoList.isEmpty() && this.dayList.isEmpty()) {
            NumberList implicitMonthDayList = new NumberList(ChronoField.DAY_OF_MONTH.range(), false);
            implicitMonthDayList.add(new TemporalAdapter<T>(rootSeed).toLocalTime().getDayOfMonth());
            ByMonthDayRule<T> implicitRule = new ByMonthDayRule<T>(implicitMonthDayList, this.frequency, this.skip);
            dates = implicitRule.apply(dates);
        }
        if (!this.dayList.isEmpty()) {
            dates = new ByDayRule<T>(this.dayList, this.deriveFilterType(), WeekDay.getDayOfWeek(this.weekStartDay)).apply(dates);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Dates after BYDAY processing: " + dates);
            }
        } else if (this.frequency == Frequency.WEEKLY || this.frequency == Frequency.YEARLY && this.yearDayList.isEmpty() && !this.weekNoList.isEmpty() && this.monthDayList.isEmpty()) {
            ByDayRule<T> implicitRule = new ByDayRule<T>(rootSeed, this.deriveFilterType(), WeekDay.getDayOfWeek(this.getWeekStartDay()));
            dates = implicitRule.apply(dates);
        }
        if (!this.hourList.isEmpty()) {
            dates = new ByHourRule<T>(this.hourList, this.frequency).apply(dates);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Dates after BYHOUR processing: " + dates);
            }
        }
        if (!this.minuteList.isEmpty()) {
            dates = new ByMinuteRule<Object>(this.minuteList, this.frequency).apply(dates);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Dates after BYMINUTE processing: " + dates);
            }
        }
        if (!this.secondList.isEmpty()) {
            dates = new BySecondRule<T>(this.secondList, this.frequency).apply(dates);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Dates after BYSECOND processing: " + dates);
            }
        }
        if (!this.setPosList.isEmpty()) {
            dates = new BySetPosRule<T>(this.setPosList).apply(dates);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Dates after SETPOS processing: " + dates);
            }
        }
        dates.sort(CANDIDATE_SORTER);
        return dates;
    }

    private void validateFrequency() {
        if (this.frequency == null) {
            throw new IllegalArgumentException("A recurrence rule MUST contain a FREQ rule part.");
        }
        if (Frequency.SECONDLY.equals((Object)this.getFrequency())) {
            this.calIncField = ChronoUnit.SECONDS;
        } else if (Frequency.MINUTELY.equals((Object)this.getFrequency())) {
            this.calIncField = ChronoUnit.MINUTES;
        } else if (Frequency.HOURLY.equals((Object)this.getFrequency())) {
            this.calIncField = ChronoUnit.HOURS;
        } else if (Frequency.DAILY.equals((Object)this.getFrequency())) {
            this.calIncField = ChronoUnit.DAYS;
        } else if (Frequency.WEEKLY.equals((Object)this.getFrequency())) {
            this.calIncField = ChronoUnit.WEEKS;
        } else if (Frequency.MONTHLY.equals((Object)this.getFrequency())) {
            this.calIncField = ChronoUnit.MONTHS;
        } else if (Frequency.YEARLY.equals((Object)this.getFrequency())) {
            this.calIncField = this.getWeekNoList().isEmpty() ? ChronoUnit.YEARS : Recur.weekBasedYears(WeekDay.getDayOfWeek(this.getWeekStartDay()));
        } else {
            throw new IllegalArgumentException("Invalid FREQ rule part '" + this.frequency + "' in recurrence rule");
        }
    }

    private static TemporalUnit weekBasedYears(DayOfWeek weekStartDay) {
        final WeekFields weekFields = weekStartDay == null ? WeekFields.of(DayOfWeek.MONDAY, 4) : WeekFields.of(weekStartDay, 4);
        return new TemporalUnit(){

            @Override
            public long between(Temporal one, Temporal other) {
                throw new UnsupportedOperationException();
            }

            @Override
            public <R extends Temporal> R addTo(R one, long other) {
                long newValue;
                TemporalField field = weekFields.weekBasedYear();
                R result = field.adjustInto(one, newValue = (long)one.get(field) + other);
                if (TemporalAdjuster.class.isAssignableFrom(result.getClass())) {
                    return (R)one.with((TemporalAdjuster)((Object)result));
                }
                return one;
            }

            @Override
            public boolean isTimeBased() {
                return false;
            }

            @Override
            public boolean isDateBased() {
                return true;
            }

            @Override
            public boolean isDurationEstimated() {
                return true;
            }

            @Override
            public Duration getDuration() {
                return WeekFields.WEEK_BASED_YEARS.getDuration();
            }
        };
    }

    @Deprecated
    public final void setCount(int count) {
        this.count = count;
        this.until = null;
    }

    @Deprecated
    public final void setFrequency(String frequency) {
        this.frequency = Frequency.valueOf(frequency);
        this.validateFrequency();
    }

    @Deprecated
    public final void setInterval(int interval) {
        this.interval = interval;
    }

    @Deprecated
    public final void setUntil(T until) {
        this.until = new TemporalAdapter<T>(until);
        this.count = -1;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.log = LoggerFactory.getLogger(Recur.class);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Recur recur = (Recur)o;
        return this.frequency == recur.frequency && this.skip == recur.skip && Objects.equals(this.until, recur.until) && this.rscale == recur.rscale && Objects.equals(this.count, recur.count) && Objects.equals(this.interval, recur.interval) && Objects.equals(this.secondList, recur.secondList) && Objects.equals(this.minuteList, recur.minuteList) && Objects.equals(this.hourList, recur.hourList) && Objects.equals(this.dayList, recur.dayList) && Objects.equals(this.monthDayList, recur.monthDayList) && Objects.equals(this.yearDayList, recur.yearDayList) && Objects.equals(this.weekNoList, recur.weekNoList) && Objects.equals(this.monthList, recur.monthList) && Objects.equals(this.setPosList, recur.setPosList) && this.weekStartDay == recur.weekStartDay;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.frequency, this.skip, this.until, this.rscale, this.count, this.interval, this.secondList, this.minuteList, this.hourList, this.dayList, this.monthDayList, this.yearDayList, this.weekNoList, this.monthList, this.setPosList, this.weekStartDay});
    }

    public static enum Skip {
        OMIT,
        BACKWARD,
        FORWARD;

    }

    public static enum RScale {
        JAPANESE("Japanese"),
        BUDDHIST("ThaiBuddhist"),
        ROC("Minguo"),
        ISLAMIC("islamic"),
        ISO8601("ISO"),
        CHINESE("ISO"),
        ETHIOPIC("Ethiopic"),
        HEBREW("ISO"),
        GREGORIAN("ISO");

        private final String chronology;

        private RScale(String chronology) {
            this.chronology = chronology;
        }

        public String getChronology() {
            return this.chronology;
        }
    }

    private class DateSpliterator
    extends Spliterators.AbstractSpliterator<T> {
        final T seed;
        final Temporal periodStart;
        final Temporal periodEnd;
        final int maxCount;
        final List<T> dates;
        T candidateSeed;
        T lastCandidate;
        Iterator<T> candidates;
        final HashSet<T> invalidCandidates;
        int noCandidateIncrementCount;
        final /* synthetic */ Recur this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public DateSpliterator(T seed, Temporal periodStart, Temporal periodEnd, int maxCount) {
            this.this$0 = (Recur)n;
            super(maxCount, 0);
            this.lastCandidate = null;
            this.candidates = null;
            this.invalidCandidates = new HashSet();
            this.noCandidateIncrementCount = 0;
            this.seed = seed;
            this.periodStart = periodStart;
            this.periodEnd = periodEnd;
            this.maxCount = maxCount;
            this.dates = new ArrayList();
            this.candidateSeed = seed;
            if (n.count == null) {
                Object incremented = n.increment(this.candidateSeed);
                while (TemporalAdapter.isBefore(incremented, periodStart)) {
                    this.candidateSeed = incremented;
                    if (this.candidateSeed == null) break;
                    incremented = n.increment(this.candidateSeed);
                }
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            boolean advance;
            boolean bl = advance = this.maxCount < 0 || this.dates.size() < this.maxCount;
            if (advance) {
                if (this.this$0.getUntil() != null && this.lastCandidate != null && TemporalAdapter.isAfter(this.lastCandidate, this.this$0.getUntil())) {
                    advance = false;
                } else if (this.periodEnd != null && this.lastCandidate != null && TemporalAdapter.isAfter(this.lastCandidate, this.periodEnd)) {
                    advance = false;
                } else if (this.this$0.getCount() >= 1 && this.dates.size() + this.invalidCandidates.size() >= this.this$0.getCount()) {
                    advance = false;
                }
            }
            if (advance) {
                while (this.candidates == null || !this.candidates.hasNext()) {
                    this.candidates = this.this$0.getCandidates(this.seed, this.candidateSeed).iterator();
                    if (!this.candidates.hasNext()) {
                        ++this.noCandidateIncrementCount;
                        if (maxIncrementCount > 0 && this.noCandidateIncrementCount > maxIncrementCount) {
                            advance = false;
                            break;
                        }
                    } else {
                        this.noCandidateIncrementCount = 0;
                    }
                    this.candidateSeed = this.this$0.increment(this.candidateSeed);
                }
            }
            if (advance) {
                this.lastCandidate = (Temporal)this.candidates.next();
                if (!TemporalAdapter.isBefore(this.lastCandidate, this.seed)) {
                    if (TemporalAdapter.isBefore(this.lastCandidate, this.periodStart) || TemporalAdapter.isAfter(this.lastCandidate, this.periodEnd)) {
                        this.invalidCandidates.add(this.lastCandidate);
                    } else if (!(TemporalAdapter.isBefore(this.lastCandidate, this.periodStart) || TemporalAdapter.isAfter(this.lastCandidate, this.periodEnd) || this.this$0.getUntil() != null && TemporalAdapter.isAfter(this.lastCandidate, this.this$0.getUntil()))) {
                        this.dates.add(this.lastCandidate);
                        action.accept(this.lastCandidate);
                    }
                }
            }
            return advance;
        }
    }

    public static class Builder<T extends Temporal> {
        private Frequency frequency;
        private Skip skip;
        private T until;
        private RScale rscale;
        private Integer count;
        private Integer interval;
        private List<Integer> secondList;
        private List<Integer> minuteList;
        private List<Integer> hourList;
        private List<WeekDay> dayList;
        private List<Integer> monthDayList;
        private List<Integer> yearDayList;
        private List<Integer> weekNoList;
        private List<Month> monthList;
        private List<Integer> setPosList;
        private WeekDay weekStartDay;

        public Builder() {
        }

        public Builder(Recur<T> recur) {
            Objects.requireNonNull(recur);
            this.frequency = recur.frequency;
            this.rscale = recur.rscale;
            this.skip = recur.skip;
            this.until = recur.until != null ? recur.until.getTemporal() : null;
            this.count = recur.count;
            this.interval = recur.interval;
            this.secondList = recur.secondList;
            this.minuteList = recur.minuteList;
            this.hourList = recur.hourList;
            this.dayList = recur.dayList;
            this.monthDayList = recur.monthDayList;
            this.yearDayList = recur.yearDayList;
            this.weekNoList = recur.weekNoList;
            this.monthList = recur.monthList;
            this.setPosList = recur.setPosList;
            this.weekStartDay = recur.weekStartDay;
        }

        public Builder<T> frequency(Frequency frequency) {
            this.frequency = frequency;
            return this;
        }

        public Builder<T> skip(Skip skip) {
            this.skip = skip;
            return this;
        }

        public Builder<T> until(T until) {
            this.until = until;
            return this;
        }

        public Builder<T> rscale(RScale rscale) {
            this.rscale = rscale;
            return this;
        }

        public Builder<T> count(Integer count) {
            this.count = count;
            return this;
        }

        public Builder<T> interval(Integer interval) {
            this.interval = interval;
            return this;
        }

        public Builder<T> secondList(Integer ... seconds) {
            return this.secondList(Arrays.asList(seconds));
        }

        public Builder<T> secondList(List<Integer> secondList) {
            this.secondList = secondList;
            return this;
        }

        public Builder<T> minuteList(Integer ... minutes) {
            return this.minuteList(Arrays.asList(minutes));
        }

        public Builder<T> minuteList(List<Integer> minuteList) {
            this.minuteList = minuteList;
            return this;
        }

        public Builder<T> hourList(Integer ... hours) {
            return this.hourList(Arrays.asList(hours));
        }

        public Builder<T> hourList(List<Integer> hourList) {
            this.hourList = hourList;
            return this;
        }

        public Builder<T> dayList(WeekDay ... days) {
            return this.dayList(new WeekDayList(days));
        }

        public Builder<T> dayList(List<WeekDay> dayList) {
            this.dayList = dayList;
            return this;
        }

        public Builder<T> monthDayList(Integer ... monthDays) {
            return this.monthDayList(Arrays.asList(monthDays));
        }

        public Builder<T> monthDayList(List<Integer> monthDayList) {
            this.monthDayList = monthDayList;
            return this;
        }

        public Builder<T> yearDayList(Integer ... yearDays) {
            return this.yearDayList(Arrays.asList(yearDays));
        }

        public Builder<T> yearDayList(List<Integer> yearDayList) {
            this.yearDayList = yearDayList;
            return this;
        }

        public Builder<T> weekNoList(Integer ... weekNos) {
            return this.weekNoList(Arrays.asList(weekNos));
        }

        public Builder<T> weekNoList(List<Integer> weekNoList) {
            this.weekNoList = weekNoList;
            return this;
        }

        public Builder<T> monthList(Month ... months) {
            return this.monthList(Arrays.asList(months));
        }

        public Builder<T> monthList(List<Month> monthList) {
            this.monthList = monthList;
            return this;
        }

        public Builder<T> setPosList(Integer ... setPos) {
            return this.setPosList(Arrays.asList(setPos));
        }

        public Builder<T> setPosList(List<Integer> setPosList) {
            this.setPosList = setPosList;
            return this;
        }

        public Builder<T> weekStartDay(WeekDay weekStartDay) {
            this.weekStartDay = weekStartDay;
            return this;
        }

        public Recur<T> build() {
            Chronology chronology = this.rscale != null ? Chronology.of(this.rscale.getChronology()) : Chronology.ofLocale(Locale.getDefault());
            Recur recur = new Recur();
            recur.frequency = this.frequency;
            recur.rscale = this.rscale;
            recur.skip = this.skip;
            if (this.until != null) {
                recur.until = new TemporalAdapter<T>(this.until);
            }
            recur.count = this.count;
            recur.interval = this.interval;
            if (this.secondList != null) {
                recur.secondList = new NumberList(this.secondList, chronology.range(ChronoField.SECOND_OF_MINUTE), false);
            }
            if (this.minuteList != null) {
                recur.minuteList = new NumberList(this.minuteList, chronology.range(ChronoField.MINUTE_OF_HOUR), false);
            }
            if (this.hourList != null) {
                recur.hourList = new NumberList(this.hourList, chronology.range(ChronoField.HOUR_OF_DAY), false);
            }
            if (this.dayList != null) {
                recur.dayList.addAll(this.dayList);
            }
            if (this.monthDayList != null) {
                recur.monthDayList = new NumberList(this.monthDayList, chronology.range(ChronoField.DAY_OF_MONTH), true);
            }
            if (this.yearDayList != null) {
                recur.yearDayList = new NumberList(this.yearDayList, chronology.range(ChronoField.DAY_OF_YEAR), true);
            }
            if (this.weekNoList != null) {
                recur.weekNoList = new NumberList(this.weekNoList, chronology.range(ChronoField.ALIGNED_WEEK_OF_YEAR), true);
            }
            if (this.monthList != null) {
                recur.monthList = new MonthList(this.monthList, chronology.range(ChronoField.MONTH_OF_YEAR));
            }
            if (this.setPosList != null) {
                recur.setPosList = new NumberList(this.setPosList, chronology.range(ChronoField.DAY_OF_YEAR), true);
            }
            recur.weekStartDay = this.weekStartDay;
            recur.validateFrequency();
            return recur;
        }
    }
}

