/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.PropertyContainer;
import net.fortuna.ical4j.model.Prototype;
import net.fortuna.ical4j.model.component.CalendarComponent;
import net.fortuna.ical4j.model.property.RecurrenceId;

public interface RecurrenceSupport<T extends CalendarComponent>
extends PropertyContainer,
Prototype<Component> {
    public <T extends Temporal> Set<Period<T>> calculateRecurrenceSet(Period<? extends Temporal> var1);

    default public List<T> getOccurrences(Period<Temporal> period) throws ParseException, IOException, URISyntaxException {
        ArrayList<CalendarComponent> occurrences = new ArrayList<CalendarComponent>();
        Set<Period<T>> periods = this.calculateRecurrenceSet(period);
        for (Period<T> p : periods) {
            CalendarComponent occurrence = (CalendarComponent)this.copy();
            occurrence.add(new RecurrenceId<T>(p.getStart()));
            occurrences.add(occurrence);
        }
        return occurrences;
    }
}

