/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.Objects;
import net.fortuna.ical4j.model.CalendarDateFormat;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.TemporalComparator;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.parameter.TzId;
import net.fortuna.ical4j.util.CompatibilityHints;
import net.fortuna.ical4j.util.TimeZones;

public class TemporalAdapter<T extends Temporal>
implements Serializable {
    private static final TemporalComparator COMPARATOR = TemporalComparator.INSTANCE;
    private final String valueString;
    private final TzId tzId;
    private final transient TimeZoneRegistry timeZoneRegistry;
    private volatile transient T temporal;

    public TemporalAdapter(TemporalAdapter<T> adapter) {
        this.temporal = adapter.temporal;
        this.valueString = adapter.valueString;
        this.tzId = adapter.tzId;
        this.timeZoneRegistry = adapter.timeZoneRegistry;
    }

    public TemporalAdapter(T temporal) {
        this(temporal, null);
    }

    public TemporalAdapter(T temporal, TimeZoneRegistry timeZoneRegistry) {
        Objects.requireNonNull(temporal, "temporal");
        this.temporal = temporal;
        this.valueString = this.toString(temporal);
        if (temporal instanceof ZonedDateTime && !TemporalAdapter.isFloating(temporal) && !TemporalAdapter.isUtc(temporal)) {
            ZoneId zoneId = ((ZonedDateTime)temporal).getZone();
            this.tzId = new TzId(zoneId.getId());
        } else {
            this.tzId = null;
        }
        this.timeZoneRegistry = timeZoneRegistry;
    }

    private TemporalAdapter(String valueString) {
        this(valueString, (TzId)null);
    }

    private TemporalAdapter(String value, TzId tzId) {
        this(value, tzId, null);
    }

    private TemporalAdapter(String value, TzId tzId, TimeZoneRegistry timeZoneRegistry) {
        this.valueString = value;
        this.tzId = tzId;
        this.timeZoneRegistry = timeZoneRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getTemporal() {
        if (this.temporal == null) {
            String string = this.valueString;
            synchronized (string) {
                if (this.temporal == null) {
                    if (this.tzId != null) {
                        try {
                            this.temporal = CalendarDateFormat.FLOATING_DATE_TIME_FORMAT.parse(this.valueString, this.tzId.toZoneId(this.timeZoneRegistry));
                        }
                        catch (DateTimeParseException e) {
                            if (CompatibilityHints.isHintEnabled("ical4j.validation.relaxed")) {
                                this.temporal = (Temporal)CalendarDateFormat.DEFAULT_PARSE_FORMAT.parse(this.valueString);
                            }
                            throw e;
                        }
                    } else {
                        this.temporal = (Temporal)CalendarDateFormat.DEFAULT_PARSE_FORMAT.parse(this.valueString);
                    }
                }
            }
        }
        return this.temporal;
    }

    public String toString() {
        return this.toString(this.getTemporal());
    }

    public String toString(ZoneId zoneId) {
        return this.toString(this.getTemporal(), zoneId);
    }

    private String toString(T temporal) {
        if (this.getTemporal() instanceof ChronoZonedDateTime) {
            return this.toString(CalendarDateFormat.FLOATING_DATE_TIME_FORMAT, ((ChronoZonedDateTime)temporal).getZone(), temporal);
        }
        return this.toString(this.getTemporal(), TimeZones.getDefault().toZoneId());
    }

    private String toString(T temporal, ZoneId zoneId) {
        if (ZoneOffset.UTC.equals(zoneId)) {
            return this.toInstantString(temporal);
        }
        if (!TemporalAdapter.isDateTimePrecision(temporal)) {
            return this.toString(CalendarDateFormat.DATE_FORMAT, temporal);
        }
        if (TemporalAdapter.isFloating(this.getTemporal())) {
            return this.toString(CalendarDateFormat.FLOATING_DATE_TIME_FORMAT, temporal);
        }
        if (TemporalAdapter.isUtc(this.getTemporal())) {
            return this.toString(CalendarDateFormat.UTC_DATE_TIME_FORMAT, temporal);
        }
        return this.toString(CalendarDateFormat.FLOATING_DATE_TIME_FORMAT, zoneId, temporal);
    }

    private String toInstantString(T temporal) {
        return this.toString(CalendarDateFormat.UTC_DATE_TIME_FORMAT, temporal);
    }

    private String toString(CalendarDateFormat format, T temporal) {
        return format.format((TemporalAccessor)temporal);
    }

    private String toString(CalendarDateFormat format, ZoneId zoneId, T temporal) {
        return format.format((TemporalAccessor)temporal, zoneId);
    }

    public ZonedDateTime toLocalTime() {
        return this.toLocalTime(TimeZones.getDefault().toZoneId());
    }

    public ZonedDateTime toLocalTime(ZoneId zoneId) {
        return TemporalAdapter.toLocalTime(this.getTemporal(), zoneId);
    }

    public static ZonedDateTime toLocalTime(Temporal temporal, ZoneId zoneId) {
        if (TemporalAdapter.isFloating(temporal)) {
            if (temporal instanceof LocalDateTime) {
                return ((LocalDateTime)temporal).atZone(zoneId);
            }
            return ((LocalDate)temporal).atStartOfDay().atZone(zoneId);
        }
        if (TemporalAdapter.isUtc(temporal)) {
            if (temporal instanceof Instant) {
                return ((Instant)temporal).atZone(zoneId);
            }
            return ((OffsetDateTime)temporal).atZoneSameInstant(zoneId);
        }
        return ZonedDateTime.from(temporal);
    }

    public static <T extends Temporal> TemporalAdapter<T> parse(String value) throws DateTimeParseException {
        return TemporalAdapter.parse(value, CalendarDateFormat.DEFAULT_PARSE_FORMAT);
    }

    public static <T extends Temporal> TemporalAdapter<T> parse(String value, CalendarDateFormat parseFormat) throws DateTimeParseException {
        return new TemporalAdapter<Temporal>((Temporal)parseFormat.parse(value));
    }

    public static TemporalAdapter<ZonedDateTime> parse(String value, ZoneId zoneId) {
        return new TemporalAdapter<ZonedDateTime>(CalendarDateFormat.FLOATING_DATE_TIME_FORMAT.parse(value, zoneId));
    }

    public static TemporalAdapter<ZonedDateTime> parse(String value, TzId tzId) {
        return new TemporalAdapter<ZonedDateTime>(value, tzId);
    }

    public static TemporalAdapter<ZonedDateTime> parse(String value, TzId tzId, TimeZoneRegistry timeZoneRegistry) {
        return new TemporalAdapter<ZonedDateTime>(value, tzId, timeZoneRegistry);
    }

    public static TemporalAdapter<?> from(Date date) {
        DateTime dateTime;
        Comparable<ChronoLocalDate> temporal = date instanceof DateTime ? ((dateTime = (DateTime)date).isUtc() ? date.toInstant() : (dateTime.getTimeZone() == null ? LocalDateTime.ofInstant(date.toInstant(), TimeZones.getDefault().toZoneId()) : ZonedDateTime.ofInstant(date.toInstant(), dateTime.getTimeZone().toZoneId()))) : LocalDate.from(date.toInstant());
        return new TemporalAdapter<LocalDate>((LocalDate)temporal);
    }

    public static boolean isFloating(Temporal date) {
        return !ChronoField.OFFSET_SECONDS.isSupportedBy(date) && !ChronoField.INSTANT_SECONDS.isSupportedBy(date);
    }

    public static boolean isUtc(Temporal date) {
        return ChronoField.INSTANT_SECONDS.isSupportedBy(date) && (!ChronoField.OFFSET_SECONDS.isSupportedBy(date) || date.get(ChronoField.OFFSET_SECONDS) == 0 && !ChronoZonedDateTime.class.isAssignableFrom(date.getClass()));
    }

    public static boolean isDateTimePrecision(Temporal date) {
        return ChronoField.INSTANT_SECONDS.isSupportedBy(date) || ChronoField.HOUR_OF_DAY.isSupportedBy(date);
    }

    public static <T extends Temporal> boolean isBefore(T date1, T date2) {
        return COMPARATOR.compare(date1, date2) < 0;
    }

    public static <T extends Temporal> boolean isAfter(T date1, T date2) {
        return COMPARATOR.compare(date1, date2) > 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemporalAdapter that = (TemporalAdapter)o;
        return this.valueString.equals(that.valueString) && Objects.equals(this.tzId, that.tzId);
    }

    public int hashCode() {
        return Objects.hash(this.valueString, this.tzId);
    }
}

