/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.util.CompatibilityHints;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class TemporalAmountAdapter
implements Serializable {
    private final TemporalAmount duration;

    public TemporalAmountAdapter(TemporalAmount duration) {
        Objects.requireNonNull(duration, "duration");
        this.duration = duration;
    }

    public TemporalAmount getDuration() {
        return this.duration;
    }

    public String toString() {
        return this.toString(LocalDateTime.now());
    }

    public String toString(Temporal seed) {
        String retVal = Duration.ZERO.equals(this.duration) || Period.ZERO.equals(this.duration) ? this.duration.toString() : (this.duration instanceof Period ? this.periodToString(((Period)this.duration).normalized(), seed) : this.durationToString((Duration)this.duration, seed));
        return retVal;
    }

    private String periodToString(Period period, Temporal seed) {
        String retVal;
        Temporal adjustedSeed = seed.plus(period);
        if (period.getYears() != 0) {
            long weeks = Math.abs(seed.until(adjustedSeed, ChronoUnit.WEEKS));
            retVal = String.format(Locale.US, "P%dW", weeks);
        } else if (period.getMonths() != 0) {
            long weeks = Math.abs(seed.until(adjustedSeed, ChronoUnit.WEEKS));
            retVal = String.format(Locale.US, "P%dW", weeks);
        } else if (period.getDays() % 7 == 0) {
            long weeks = Math.abs(seed.until(adjustedSeed, ChronoUnit.WEEKS));
            retVal = String.format(Locale.US, "P%dW", weeks);
        } else {
            long days = Math.abs(seed.until(adjustedSeed, ChronoUnit.DAYS));
            retVal = String.format(Locale.US, "P%dD", days);
        }
        if (period.isNegative() && !retVal.startsWith("-")) {
            return "-" + retVal;
        }
        return retVal;
    }

    private String durationToString(Duration duration, Temporal seed) {
        String retVal = null;
        Duration absDuration = duration.abs();
        Temporal adjustedSeed = seed.plus(absDuration);
        long days = 0L;
        if (duration.getSeconds() != 0L) {
            days = seed.until(adjustedSeed, ChronoUnit.DAYS);
        }
        if (days != 0L) {
            Duration durationMinusDays = absDuration.minusDays(days);
            if (durationMinusDays.getSeconds() != 0L) {
                adjustedSeed = seed.plus(durationMinusDays);
                long hours = seed.until(adjustedSeed, ChronoUnit.HOURS);
                adjustedSeed = seed.plus(durationMinusDays.minusHours(hours));
                long minutes = seed.until(adjustedSeed, ChronoUnit.MINUTES);
                adjustedSeed = seed.plus(durationMinusDays.minusHours(hours).minusMinutes(minutes));
                long seconds = seed.until(adjustedSeed, ChronoUnit.SECONDS);
                if (hours > 0L) {
                    retVal = seconds > 0L ? String.format(Locale.US, "P%dDT%dH%dM%dS", days, hours, minutes, seconds) : (minutes > 0L ? String.format(Locale.US, "P%dDT%dH%dM", days, hours, minutes) : String.format(Locale.US, "P%dDT%dH", days, hours));
                } else if (minutes > 0L) {
                    retVal = seconds > 0L ? String.format(Locale.US, "P%dDT%dM%dS", days, minutes, seconds) : String.format(Locale.US, "P%dDT%dM", days, minutes);
                } else if (seconds > 0L) {
                    retVal = String.format(Locale.US, "P%dDT%dS", days, seconds);
                }
            } else {
                retVal = String.format(Locale.US, "P%dD", days);
            }
        } else {
            retVal = absDuration.toString();
        }
        if (duration.isNegative()) {
            return "-" + retVal;
        }
        return retVal;
    }

    public Duration toDuration() {
        if (this.duration instanceof Duration) {
            return (Duration)this.duration;
        }
        LocalDateTime seed = LocalDateTime.now();
        long days = seed.until(seed.plus(this.duration), ChronoUnit.DAYS);
        return Duration.ofDays(days);
    }

    public static TemporalAmountAdapter parse(String value) {
        return TemporalAmountAdapter.parse(value, CompatibilityHints.isHintEnabled("ical4j.parsing.relaxed"));
    }

    public static TemporalAmountAdapter parse(String value, boolean lenient) {
        TemporalAmount retVal = Arrays.asList("P", "PT").contains(value) && lenient ? Period.ZERO : (value.matches("([+-])?P.*(W|D)") ? Period.parse(value) : (lenient && value.matches("P([+-]?[0-9]*[MHS])+") ? Duration.parse("PT" + value.substring(1)) : Duration.parse(value)));
        return new TemporalAmountAdapter(retVal);
    }

    public static TemporalAmountAdapter from(Temporal start, Temporal end) {
        if (start instanceof LocalDate) {
            return TemporalAmountAdapter.from((LocalDate)start, (LocalDate)end);
        }
        return new TemporalAmountAdapter(Duration.between(start, end));
    }

    public static TemporalAmountAdapter from(LocalDate start, LocalDate end) {
        return new TemporalAmountAdapter(Period.between(start, end));
    }

    public static TemporalAmountAdapter fromDateRange(Date start, Date end) {
        long durationMillis = end.getTime() - start.getTime();
        TemporalAmount duration = durationMillis % 86400000L == 0L ? Period.ofDays((int)(durationMillis / 86400000L)) : Duration.ofMillis(durationMillis);
        return new TemporalAmountAdapter(duration);
    }

    public static TemporalAmountAdapter from(Dur dur) {
        TemporalAmount duration;
        if (dur.getWeeks() > 0) {
            Period p = Period.ofWeeks(dur.getWeeks());
            if (dur.isNegative()) {
                p = p.negated();
            }
            duration = p;
        } else {
            Duration d = Duration.ofDays(dur.getDays()).plusHours(dur.getHours()).plusMinutes(dur.getMinutes()).plusSeconds(dur.getSeconds());
            if (dur.isNegative()) {
                d = d.negated();
            }
            duration = d;
        }
        return new TemporalAmountAdapter(duration);
    }

    public static TemporalAmountAdapter between(Temporal t1, Temporal t2) {
        TemporalAmount difference = t1 instanceof LocalDate && t2 instanceof LocalDate ? Period.between((LocalDate)t1, (LocalDate)t2) : Duration.between(t1, t2);
        return new TemporalAmountAdapter(difference);
    }

    @Deprecated
    public final Date getTime(Date start) {
        return Date.from(Instant.from(this.duration.addTo(start.toInstant())));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemporalAmountAdapter that = (TemporalAmountAdapter)o;
        return new EqualsBuilder().append((Object)this.duration, (Object)that.duration).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.duration).toHashCode();
    }
}

