/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalUnit;
import java.util.Comparator;
import net.fortuna.ical4j.util.TimeZones;

public class TemporalComparator
implements Comparator<Temporal> {
    public static final TemporalComparator INSTANCE = new TemporalComparator();
    private final TemporalUnit defaultComparisonUnit;
    private final ZoneId defaultZoneId;

    public TemporalComparator() {
        this(ChronoUnit.SECONDS, TimeZones.getDefault().toZoneId());
    }

    public TemporalComparator(TemporalUnit defaultComparisonUnit) {
        this(defaultComparisonUnit, TimeZones.getDefault().toZoneId());
    }

    public TemporalComparator(ZoneId defaultZoneId) {
        this(ChronoUnit.SECONDS, defaultZoneId);
    }

    public TemporalComparator(TemporalUnit defaultComparisonUnit, ZoneId defaultZoneId) {
        this.defaultComparisonUnit = defaultComparisonUnit;
        this.defaultZoneId = defaultZoneId;
    }

    @Override
    public int compare(Temporal o1, Temporal o2) {
        long diff;
        Comparable<OffsetDateTime> l1;
        if (o1 instanceof Instant) {
            Instant i1 = (Instant)o1;
            if (o2 instanceof Instant) {
                return this.compare(i1, (Instant)o2);
            }
            if (o2 instanceof OffsetDateTime) {
                return this.compare(i1, (OffsetDateTime)o2);
            }
            if (o2 instanceof LocalDateTime) {
                return this.compare(i1, (LocalDateTime)o2);
            }
            if (o2 instanceof LocalDate) {
                return this.compare(i1, (LocalDate)o2);
            }
        } else if (o1 instanceof OffsetDateTime) {
            l1 = (OffsetDateTime)o1;
            if (o2 instanceof Instant) {
                return this.compare((OffsetDateTime)l1, (Instant)o2);
            }
            if (o2 instanceof LocalDateTime) {
                return this.compare((OffsetDateTime)l1, (LocalDateTime)o2);
            }
            if (o2 instanceof LocalDate) {
                return this.compare((OffsetDateTime)l1, (LocalDate)o2);
            }
        } else if (o1 instanceof LocalDateTime) {
            l1 = (LocalDateTime)o1;
            if (o2 instanceof Instant) {
                return this.compare((LocalDateTime)l1, (Instant)o2);
            }
            if (o2 instanceof OffsetDateTime) {
                return this.compare((LocalDateTime)l1, (OffsetDateTime)o2);
            }
            if (o2 instanceof LocalDateTime) {
                return this.compare((LocalDateTime)l1, (LocalDateTime)o2);
            }
            if (o2 instanceof LocalDate) {
                return this.compare((LocalDateTime)l1, (LocalDate)o2);
            }
        } else if (o1 instanceof LocalDate) {
            l1 = (LocalDate)o1;
            if (o2 instanceof Instant) {
                return this.compare((LocalDate)l1, (Instant)o2);
            }
            if (o2 instanceof OffsetDateTime) {
                return this.compare((LocalDate)l1, (OffsetDateTime)o2);
            }
            if (o2 instanceof LocalDateTime) {
                return this.compare((LocalDate)l1, (LocalDateTime)o2);
            }
            if (o2 instanceof LocalDate) {
                return this.compare((LocalDate)l1, (LocalDate)o2);
            }
        }
        return (diff = this.defaultComparisonUnit.between(o2, o1)) > 0L ? Integer.MAX_VALUE : (diff < 0L ? Integer.MIN_VALUE : 0);
    }

    @Override
    public int compare(Instant o1, Instant o2) {
        return o1.compareTo(o2);
    }

    @Override
    public int compare(OffsetDateTime o1, OffsetDateTime o2) {
        return o1.compareTo(o2);
    }

    @Override
    public int compare(LocalDateTime o1, LocalDateTime o2) {
        return o1.compareTo(o2);
    }

    @Override
    public int compare(LocalDate o1, LocalDate o2) {
        return o1.compareTo(o2);
    }

    @Override
    public int compare(Instant o1, LocalDateTime o2) {
        return o1.compareTo(ZonedDateTime.of(o2, this.defaultZoneId).toInstant());
    }

    @Override
    public int compare(LocalDateTime o1, Instant o2) {
        return ZonedDateTime.of(o1, this.defaultZoneId).toInstant().compareTo(o2);
    }

    @Override
    public int compare(Instant o1, OffsetDateTime o2) {
        return o1.compareTo(o2.toInstant());
    }

    @Override
    public int compare(OffsetDateTime o1, Instant o2) {
        return o1.toInstant().compareTo(o2);
    }

    @Override
    public int compare(OffsetDateTime o1, LocalDateTime o2) {
        return o1.compareTo(OffsetDateTime.of(o2, this.defaultZoneId.getRules().getOffset(o2)));
    }

    @Override
    public int compare(LocalDateTime o1, OffsetDateTime o2) {
        return OffsetDateTime.of(o1, this.defaultZoneId.getRules().getOffset(o1)).compareTo(o2);
    }

    @Override
    public int compare(Instant o1, LocalDate o2) {
        return this.compare(o1, o2.atStartOfDay());
    }

    @Override
    public int compare(LocalDate o1, Instant o2) {
        return this.compare(o1.atStartOfDay(), o2);
    }

    @Override
    public int compare(OffsetDateTime o1, LocalDate o2) {
        return this.compare(o1, o2.atStartOfDay());
    }

    @Override
    public int compare(LocalDate o1, OffsetDateTime o2) {
        return this.compare(o1.atStartOfDay(), o2);
    }

    @Override
    public int compare(LocalDateTime o1, LocalDate o2) {
        return this.compare(o1, o2.atStartOfDay());
    }

    @Override
    public int compare(LocalDate o1, LocalDateTime o2) {
        return this.compare(o1.atStartOfDay(), o2);
    }
}

