/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.fortuna.ical4j.util.Strings;

public class TextList
implements Serializable {
    private static final long serialVersionUID = -417427815871330636L;
    private static final Pattern PATTERN = Pattern.compile("(?:\\\\.|[^\\\\,]++)+");
    private final Set<String> texts;

    public TextList() {
        this.texts = Collections.emptySet();
    }

    public TextList(String aValue) {
        ArrayList<String> values = new ArrayList<String>();
        Matcher matcher = PATTERN.matcher(aValue);
        while (matcher.find()) {
            values.add(Strings.unescape(matcher.group().replace("\\\\", "\\")));
        }
        this.texts = Set.copyOf(values);
    }

    public TextList(List<String> texts) {
        this.texts = Set.copyOf(texts);
    }

    public TextList(String ... textValues) {
        this.texts = Set.copyOf(Arrays.asList(textValues));
    }

    public final String toString() {
        return this.texts.stream().map(Strings::escape).collect(Collectors.joining(","));
    }

    public final TextList add(String text) {
        ArrayList<String> newlist = new ArrayList<String>(this.texts);
        newlist.add(text);
        return new TextList(newlist);
    }

    public final TextList remove(String text) {
        ArrayList<String> newlist = new ArrayList<String>(this.texts);
        if (newlist.remove(text)) {
            return new TextList(newlist);
        }
        return this;
    }

    public Set<String> getTexts() {
        return this.texts;
    }
}

