/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.fortuna.ical4j.model.component.Daylight;
import net.fortuna.ical4j.model.component.Observance;
import net.fortuna.ical4j.model.component.Standard;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.property.TzId;
import net.fortuna.ical4j.model.property.TzOffsetFrom;
import net.fortuna.ical4j.model.property.TzOffsetTo;
import net.fortuna.ical4j.util.CompatibilityHints;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeZone
extends java.util.TimeZone {
    private static final long serialVersionUID = -5620979316746547234L;
    private static final Logger LOG = LoggerFactory.getLogger(TimeZone.class);
    private final VTimeZone vTimeZone;
    private final int rawOffset;
    private final boolean negativeDstSupported;

    public TimeZone(VTimeZone vTimeZone) {
        this(vTimeZone, CompatibilityHints.isHintEnabled("net.fortuna.ical4j.timezone.offset.negative_dst_supported"));
    }

    public TimeZone(VTimeZone vTimeZone, boolean negativeDstSupported) {
        this.vTimeZone = vTimeZone;
        Optional<TzId> tzId = vTimeZone.getTimeZoneId();
        if (!tzId.isPresent()) {
            throw new IllegalArgumentException("Invalid timezone argument");
        }
        this.setID(tzId.get().getValue());
        this.rawOffset = TimeZone.getRawOffset(vTimeZone);
        this.negativeDstSupported = negativeDstSupported;
    }

    @Override
    public final int getOffset(int era, int year, int month, int dayOfMonth, int dayOfWeek, int milliseconds) {
        int ms = milliseconds;
        int hour = ms / 3600000;
        int minute = (ms -= hour * 3600000) / 60000;
        ms -= minute * 60000;
        int second = ms / 1000;
        OffsetDateTime date = OffsetDateTime.of(year, month + 1, dayOfMonth, hour, minute, second, (ms -= second * 1000) * 1000, ZoneOffset.ofTotalSeconds(this.getRawOffset() / 1000));
        Observance observance = this.vTimeZone.getApplicableObservance(date);
        if (observance != null) {
            TzOffsetTo offset = (TzOffsetTo)observance.getRequiredProperty("TZOFFSETTO");
            return (int)((long)offset.getOffset().getTotalSeconds() * 1000L);
        }
        return 0;
    }

    @Override
    public int getOffset(long date) {
        Observance observance = this.vTimeZone.getApplicableObservance(Instant.ofEpochMilli(date));
        if (observance != null) {
            TzOffsetTo offsetTo = (TzOffsetTo)observance.getRequiredProperty("TZOFFSETTO");
            if ((long)offsetTo.getOffset().getTotalSeconds() * 1000L < (long)this.getRawOffset()) {
                return this.getRawOffset();
            }
            return (int)((long)offsetTo.getOffset().getTotalSeconds() * 1000L);
        }
        return 0;
    }

    private boolean isNegativeOffset(Observance observance) {
        TzOffsetTo offsetTo = (TzOffsetTo)observance.getRequiredProperty("TZOFFSETTO");
        TzOffsetFrom offsetFrom = (TzOffsetFrom)observance.getRequiredProperty("TZOFFSETFROM");
        return offsetFrom.getOffset().compareTo(offsetTo.getOffset()) < 0;
    }

    @Override
    public final int getRawOffset() {
        return this.rawOffset;
    }

    @Override
    public final boolean inDaylightTime(Date date) {
        Observance observance = this.vTimeZone.getApplicableObservance(date.toInstant());
        return observance instanceof Daylight && (!this.negativeDstSupported || !this.isNegativeOffset(observance));
    }

    @Override
    public final void setRawOffset(int offsetMillis) {
        throw new UnsupportedOperationException("Updates to the VTIMEZONE object must be performed directly");
    }

    @Override
    public final boolean useDaylightTime() {
        List daylights = this.vTimeZone.getComponents("DAYLIGHT");
        return !daylights.isEmpty();
    }

    public final VTimeZone getVTimeZone() {
        return this.vTimeZone;
    }

    private static int getRawOffset(VTimeZone vt) {
        Optional<TzOffsetTo> offsetTo;
        List seasonalTimes = vt.getComponents("STANDARD");
        if (seasonalTimes.isEmpty() && (seasonalTimes = vt.getComponents("DAYLIGHT")).isEmpty()) {
            return 0;
        }
        Observance latestSeasonalTime = null;
        if (seasonalTimes.size() > 1) {
            OffsetDateTime latestOnset = null;
            for (Observance seasonalTime : seasonalTimes) {
                OffsetDateTime onset = seasonalTime.getLatestOnset(Instant.now());
                if (onset == null || latestOnset != null && !onset.isAfter(latestOnset)) continue;
                latestOnset = onset;
                latestSeasonalTime = seasonalTime;
            }
        } else {
            latestSeasonalTime = (Observance)seasonalTimes.get(0);
        }
        if (latestSeasonalTime instanceof Daylight) {
            Optional<TzOffsetFrom> offsetFrom = latestSeasonalTime.getTimeZoneOffsetFrom();
            if (offsetFrom.isPresent()) {
                return (int)((long)offsetFrom.get().getOffset().getTotalSeconds() * 1000L);
            }
        } else if (latestSeasonalTime instanceof Standard && (offsetTo = latestSeasonalTime.getTimeZoneOffsetTo()).isPresent()) {
            return (int)((long)offsetTo.get().getOffset().getTotalSeconds() * 1000L);
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeZone timeZone = (TimeZone)o;
        return this.rawOffset == timeZone.rawOffset && Objects.equals(this.vTimeZone, timeZone.vTimeZone);
    }

    public int hashCode() {
        int result = this.vTimeZone != null ? this.vTimeZone.hashCode() : 0;
        result = 31 * result + this.rawOffset;
        return result;
    }
}

