/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.time.ZoneId;
import java.time.zone.ZoneRules;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.TimeZoneRegistryImpl;

public interface TimeZoneRegistry {
    public static final Map<String, String> ZONE_IDS = new ConcurrentHashMap<String, String>();
    public static final Map<String, String> ZONE_ALIASES = new ConcurrentHashMap<String, String>();

    public static ZoneId getGlobalZoneId(String tzId) {
        Objects.requireNonNull(tzId, "tzId");
        Set<String> ids = ZoneId.getAvailableZoneIds();
        try {
            Class.forName(TimeZoneRegistryImpl.class.getCanonicalName());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        ZoneId zoneId = ZoneId.of(tzId, ZONE_ALIASES);
        Optional<Map.Entry> lookup = ZONE_IDS.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(zoneId.getId())).findFirst();
        return lookup.map(mapping -> ZoneId.of((String)mapping.getKey())).orElse(zoneId);
    }

    public void register(TimeZone var1);

    public void register(TimeZone var1, boolean var2);

    public void clear();

    public TimeZone getTimeZone(String var1);

    public Map<String, ZoneRules> getZoneRules();

    public ZoneId getZoneId(String var1);

    public String getTzId(String var1);
}

