/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.io.IOException;
import java.io.InputStream;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.zone.ZoneRules;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.TimeZoneLoader;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.ZoneRulesBuilder;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.util.CompatibilityHints;
import net.fortuna.ical4j.util.ResourceLoader;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeZoneRegistryImpl
implements TimeZoneRegistry {
    private static final String DEFAULT_RESOURCE_PREFIX = "zoneinfo/";
    private static final Pattern TZ_ID_SUFFIX = Pattern.compile("(?<=/)[^/]*/[^/]*$");
    private static final Map<String, TimeZone> DEFAULT_TIMEZONES = new ConcurrentHashMap<String, TimeZone>();
    private static final Properties ALIASES = new Properties();
    private final TimeZoneLoader timeZoneLoader;
    private final Map<String, TimeZone> timezones;
    private final Map<String, ZoneRules> zoneRules;
    private final Map<String, String> zoneIds;
    private final boolean lenientTzResolution;

    public TimeZoneRegistryImpl() {
        this(DEFAULT_RESOURCE_PREFIX, CompatibilityHints.isHintEnabled("ical4j.parsing.relaxed"));
    }

    public TimeZoneRegistryImpl(String resourcePrefix) {
        this(resourcePrefix, CompatibilityHints.isHintEnabled("ical4j.parsing.relaxed"));
    }

    public TimeZoneRegistryImpl(String resourcePrefix, boolean lenientTzResolution) {
        this.timeZoneLoader = TimeZoneLoader.getInstance(resourcePrefix);
        this.timezones = new ConcurrentHashMap<String, TimeZone>();
        this.zoneRules = new ConcurrentHashMap<String, ZoneRules>();
        this.zoneIds = new HashMap<String, String>();
        this.lenientTzResolution = lenientTzResolution;
    }

    @Override
    public final void register(TimeZone timezone) {
        this.register(timezone, false);
    }

    @Override
    public final void register(TimeZone timezone, boolean update) {
        if (update) {
            try {
                this.timezones.put(timezone.getID(), new TimeZone(this.timeZoneLoader.loadVTimeZone(timezone.getID())));
            }
            catch (IOException | ParserException e) {
                Logger log = LoggerFactory.getLogger(TimeZoneRegistryImpl.class);
                log.warn("Error occurred loading VTimeZone", (Throwable)e);
            }
        } else {
            this.timezones.put(timezone.getID(), timezone);
        }
        ZoneRules newZoneRules = new ZoneRulesBuilder().vTimeZone(this.timezones.get(timezone.getID()).getVTimeZone()).build();
        String globalId = "ical4j~" + UUID.randomUUID();
        this.zoneIds.put(globalId, timezone.getID());
        this.zoneRules.put(globalId, newZoneRules);
    }

    @Override
    public final void clear() {
        this.timezones.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final TimeZone getTimeZone(String id) {
        TimeZone timezone = this.timezones.get(id);
        if (timezone == null) {
            Validate.notBlank((CharSequence)id, (String)"Invalid TimeZone ID: [%s]", (Object[])new Object[]{id});
            timezone = DEFAULT_TIMEZONES.get(id);
            if (timezone == null) {
                String alias = ALIASES.getProperty(id);
                if (alias != null) {
                    return this.getTimeZone(alias);
                }
                Map<String, TimeZone> map = DEFAULT_TIMEZONES;
                synchronized (map) {
                    timezone = DEFAULT_TIMEZONES.get(id);
                    if (timezone == null) {
                        try {
                            Matcher matcher;
                            VTimeZone vTimeZone = this.timeZoneLoader.loadVTimeZone(id);
                            if (vTimeZone != null) {
                                timezone = new TimeZone(vTimeZone);
                                DEFAULT_TIMEZONES.put(timezone.getID(), timezone);
                                if (!timezone.getID().equals(id)) {
                                    DEFAULT_TIMEZONES.put(id, timezone);
                                }
                            } else if (this.lenientTzResolution && (matcher = TZ_ID_SUFFIX.matcher(id)).find()) {
                                return this.getTimeZone(matcher.group());
                            }
                        }
                        catch (IOException | ParserException e) {
                            Logger log = LoggerFactory.getLogger(TimeZoneRegistryImpl.class);
                            log.warn("Error occurred loading VTimeZone", (Throwable)e);
                        }
                    }
                }
            }
        }
        return timezone;
    }

    @Override
    public Map<String, ZoneRules> getZoneRules() {
        return this.zoneRules;
    }

    @Override
    public ZoneId getZoneId(String tzId) {
        return ZoneId.of((String)this.zoneIds.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(tzId)).findFirst().orElseThrow(() -> new DateTimeException(String.format("Unknown timezone identifier [%s]", tzId))).getKey(), TimeZoneRegistry.ZONE_ALIASES);
    }

    @Override
    public String getTzId(String zoneId) {
        return this.zoneIds.get(zoneId);
    }

    static {
        for (String aliasResource : Arrays.asList("net/fortuna/ical4j/model/tz.alias", "net/fortuna/ical4j/transform/compliance/msTimezoneNames", "net/fortuna/ical4j/transform/compliance/msTimezoneIds")) {
            try {
                InputStream aliasInputStream = ResourceLoader.getResourceAsStream(aliasResource);
                try {
                    ALIASES.load(aliasInputStream);
                }
                finally {
                    if (aliasInputStream == null) continue;
                    aliasInputStream.close();
                }
            }
            catch (IOException | NullPointerException e) {
                LoggerFactory.getLogger(TimeZoneRegistryImpl.class).warn("Error loading timezone aliases: {}", (Object)e.getMessage());
            }
        }
        try (InputStream aliasInputStream = ResourceLoader.getResourceAsStream("tz.alias");){
            ALIASES.load(aliasInputStream);
        }
        catch (IOException | NullPointerException e) {
            LoggerFactory.getLogger(TimeZoneRegistryImpl.class).debug("No custom timezone aliases: {}", (Object)e.getMessage());
        }
        for (String alias : ALIASES.stringPropertyNames()) {
            TimeZoneRegistry.ZONE_ALIASES.put(alias, ALIASES.getProperty(alias));
        }
    }
}

