/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Optional;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.property.TzUrl;
import net.fortuna.ical4j.util.Configurator;
import org.slf4j.LoggerFactory;

public class TimeZoneUpdater {
    private static final String UPDATE_ENABLED = "net.fortuna.ical4j.timezone.update.enabled";
    private static final String UPDATE_CONNECT_TIMEOUT = "net.fortuna.ical4j.timezone.update.timeout.connect";
    private static final String UPDATE_READ_TIMEOUT = "net.fortuna.ical4j.timezone.update.timeout.read";
    private static final String UPDATE_PROXY_ENABLED = "net.fortuna.ical4j.timezone.update.proxy.enabled";
    private static final String UPDATE_PROXY_TYPE = "net.fortuna.ical4j.timezone.update.proxy.type";
    private static final String UPDATE_PROXY_HOST = "net.fortuna.ical4j.timezone.update.proxy.host";
    private static final String UPDATE_PROXY_PORT = "net.fortuna.ical4j.timezone.update.proxy.port";
    private static final String UPDATE_SCHEME_OVERRIDE = "net.fortuna.ical4j.timezone.update.scheme";
    private static final String UPDATE_HOST_OVERRIDE = "net.fortuna.ical4j.timezone.update.host";
    private static final String UPDATE_PORT_OVERRIDE = "net.fortuna.ical4j.timezone.update.port";
    private static final String SECURE_CONNECTION_ENABLED = "net.fortuna.ical4j.timezone.update.connection.secure";
    private Proxy proxy = null;

    public TimeZoneUpdater() {
        try {
            if ("true".equals(Configurator.getProperty(UPDATE_PROXY_ENABLED).orElse("false"))) {
                Proxy.Type type = Configurator.getEnumProperty(Proxy.Type.class, UPDATE_PROXY_TYPE).orElse(Proxy.Type.DIRECT);
                String proxyHost = Configurator.getProperty(UPDATE_PROXY_HOST).orElse("");
                int proxyPort = Configurator.getIntProperty(UPDATE_PROXY_PORT).orElse(-1);
                this.proxy = new Proxy(type, new InetSocketAddress(proxyHost, proxyPort));
            }
        }
        catch (Throwable e) {
            LoggerFactory.getLogger(TimeZoneUpdater.class).warn("Error loading proxy server configuration: " + e.getMessage());
        }
    }

    public boolean isEnabled() {
        return !"false".equals(Configurator.getProperty(UPDATE_ENABLED).orElse("true"));
    }

    public URLConnection openConnection(URL url) throws IOException {
        int connectTimeout = Configurator.getIntProperty(UPDATE_CONNECT_TIMEOUT).orElse(0);
        int readTimeout = Configurator.getIntProperty(UPDATE_READ_TIMEOUT).orElse(0);
        URLConnection connection = "true".equals(Configurator.getProperty(UPDATE_PROXY_ENABLED).orElse("false")) && this.proxy != null ? url.openConnection(this.proxy) : url.openConnection();
        connection.setConnectTimeout(connectTimeout);
        connection.setReadTimeout(readTimeout);
        return connection;
    }

    public VTimeZone updateDefinition(VTimeZone vTimeZone) {
        Optional<TzUrl> tzUrl;
        if (this.isEnabled() && vTimeZone != null && (tzUrl = vTimeZone.getTimeZoneUrl()).isPresent()) {
            try {
                boolean secureScheme = "true".equals(Configurator.getProperty(SECURE_CONNECTION_ENABLED).orElse("false"));
                URL updateUrl = new UrlBuilder(tzUrl.get().getUri()).withScheme(Configurator.getProperty(UPDATE_SCHEME_OVERRIDE).orElse(secureScheme ? "https" : null)).withHost(Configurator.getProperty(UPDATE_HOST_OVERRIDE).orElse(null)).withPort(Configurator.getIntProperty(UPDATE_PORT_OVERRIDE).orElse(-1)).toUrl();
                URLConnection connection = this.openConnection(updateUrl);
                CalendarBuilder builder = new CalendarBuilder();
                Calendar calendar = builder.build(connection.getInputStream());
                Optional updatedVTimeZone = calendar.getComponent("VTIMEZONE");
                if (updatedVTimeZone.isPresent()) {
                    return (VTimeZone)updatedVTimeZone.get();
                }
            }
            catch (IOException | URISyntaxException | ParserException e) {
                LoggerFactory.getLogger(TimeZoneUpdater.class).warn("Error updating timezone definition", (Throwable)e);
            }
        }
        return vTimeZone;
    }

    private static class UrlBuilder {
        private final URI base;
        private String scheme;
        private String host;
        private int port;

        public UrlBuilder(URI base) {
            this.base = base;
        }

        public UrlBuilder withScheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public UrlBuilder withHost(String host) {
            this.host = host;
            return this;
        }

        public UrlBuilder withPort(int port) {
            this.port = port;
            return this;
        }

        URL toUrl() throws MalformedURLException, URISyntaxException {
            URI uri = this.base;
            if (this.scheme != null) {
                uri = new URI(this.scheme, uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            if (this.host != null) {
                uri = new URI(uri.getScheme(), uri.getUserInfo(), this.host, uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            if (this.port > 0) {
                uri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), this.port, uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            return uri.toURL();
        }
    }
}

