/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.io.Serializable;
import java.time.DayOfWeek;
import java.util.Calendar;
import java.util.Objects;
import net.fortuna.ical4j.util.Numbers;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class WeekDay
implements Serializable {
    private static final long serialVersionUID = -4412000990022011469L;
    public static final WeekDay SU = new WeekDay(Day.SU, 0);
    public static final WeekDay MO = new WeekDay(Day.MO, 0);
    public static final WeekDay TU = new WeekDay(Day.TU, 0);
    public static final WeekDay WE = new WeekDay(Day.WE, 0);
    public static final WeekDay TH = new WeekDay(Day.TH, 0);
    public static final WeekDay FR = new WeekDay(Day.FR, 0);
    public static final WeekDay SA = new WeekDay(Day.SA, 0);
    private final Day day;
    private final int offset;

    public WeekDay(String value) {
        this.offset = value.length() > 2 ? Numbers.parseInt(value.substring(0, value.length() - 2)) : 0;
        this.day = Day.valueOf(value.substring(value.length() - 2));
    }

    private WeekDay(Day day, int offset) {
        Objects.requireNonNull(day, "day");
        this.day = day;
        this.offset = offset;
    }

    public WeekDay(WeekDay weekDay, int offset) {
        Objects.requireNonNull(weekDay, "weekDay");
        this.day = weekDay.getDay();
        this.offset = offset;
    }

    public final Day getDay() {
        return this.day;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final String toString() {
        StringBuilder b = new StringBuilder();
        if (this.getOffset() != 0) {
            b.append(this.getOffset());
        }
        b.append((Object)this.getDay());
        return b.toString();
    }

    public static WeekDay getWeekDay(Day day) {
        switch (day) {
            case SU: {
                return SU;
            }
            case MO: {
                return MO;
            }
            case TU: {
                return TU;
            }
            case WE: {
                return WE;
            }
            case TH: {
                return TH;
            }
            case FR: {
                return FR;
            }
            case SA: {
                return SA;
            }
        }
        return null;
    }

    public static WeekDay getWeekDay(Calendar cal) {
        return WeekDay.getDay(cal.get(7));
    }

    public static WeekDay getWeekDay(DayOfWeek dayOfWeek) {
        switch (dayOfWeek) {
            case SUNDAY: {
                return SU;
            }
            case MONDAY: {
                return MO;
            }
            case TUESDAY: {
                return TU;
            }
            case WEDNESDAY: {
                return WE;
            }
            case THURSDAY: {
                return TH;
            }
            case FRIDAY: {
                return FR;
            }
            case SATURDAY: {
                return SA;
            }
        }
        return null;
    }

    public static WeekDay getMonthlyOffset(Calendar cal) {
        return new WeekDay(WeekDay.getDay(cal.get(7)), cal.get(8));
    }

    public static WeekDay getNegativeMonthlyOffset(Calendar cal) {
        Calendar calClone = (Calendar)cal.clone();
        int delta = -1;
        do {
            calClone.add(6, 7);
        } while (calClone.get(2) == cal.get(2) && --delta > -5);
        return new WeekDay(WeekDay.getDay(cal.get(7)), delta);
    }

    public static WeekDay getDay(int calDay) {
        switch (calDay) {
            case 1: {
                return SU;
            }
            case 2: {
                return MO;
            }
            case 3: {
                return TU;
            }
            case 4: {
                return WE;
            }
            case 5: {
                return TH;
            }
            case 6: {
                return FR;
            }
            case 7: {
                return SA;
            }
        }
        return null;
    }

    public static int getCalendarDay(WeekDay weekday) {
        switch (weekday.day) {
            case SU: {
                return 1;
            }
            case MO: {
                return 2;
            }
            case TU: {
                return 3;
            }
            case WE: {
                return 4;
            }
            case TH: {
                return 5;
            }
            case FR: {
                return 6;
            }
            case SA: {
                return 7;
            }
        }
        return -1;
    }

    public static DayOfWeek getDayOfWeek(WeekDay weekday) {
        if (weekday == null) {
            return null;
        }
        switch (weekday.day) {
            case SU: {
                return DayOfWeek.SUNDAY;
            }
            case MO: {
                return DayOfWeek.MONDAY;
            }
            case TU: {
                return DayOfWeek.TUESDAY;
            }
            case WE: {
                return DayOfWeek.WEDNESDAY;
            }
            case TH: {
                return DayOfWeek.THURSDAY;
            }
            case FR: {
                return DayOfWeek.FRIDAY;
            }
            case SA: {
                return DayOfWeek.SATURDAY;
            }
        }
        return null;
    }

    public final boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (!(arg0 instanceof WeekDay)) {
            return false;
        }
        WeekDay wd = (WeekDay)arg0;
        return Objects.equals((Object)wd.getDay(), (Object)this.getDay()) && wd.getOffset() == this.getOffset();
    }

    public final int hashCode() {
        return new HashCodeBuilder().append((Object)this.getDay()).append(this.getOffset()).toHashCode();
    }

    public static enum Day {
        SU,
        MO,
        TU,
        WE,
        TH,
        FR,
        SA;

    }
}

