/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDateTime;
import java.time.zone.ZoneOffsetTransition;
import java.time.zone.ZoneOffsetTransitionRule;
import java.time.zone.ZoneRules;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fortuna.ical4j.model.ConstraintViolationException;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.TemporalComparator;
import net.fortuna.ical4j.model.WeekDay;
import net.fortuna.ical4j.model.component.Observance;
import net.fortuna.ical4j.model.component.Standard;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.RRule;
import net.fortuna.ical4j.model.property.TzOffsetFrom;
import net.fortuna.ical4j.model.property.TzOffsetTo;

public class ZoneRulesBuilder {
    private VTimeZone vTimeZone;

    public ZoneRulesBuilder vTimeZone(VTimeZone vTimeZone) {
        this.vTimeZone = vTimeZone;
        return this;
    }

    private List<ZoneOffsetTransition> buildStandardOffsetTransitions(List<Standard> observances) {
        ArrayList<ZoneOffsetTransition> transitions = new ArrayList<ZoneOffsetTransition>();
        ZoneOffset prevOffset = null;
        ArrayList<Standard> sorted = new ArrayList<Standard>(observances);
        sorted.sort((o1, o2) -> {
            DtStart o1Start = (DtStart)o1.getRequiredProperty("DTSTART");
            DtStart o2Start = (DtStart)o2.getRequiredProperty("DTSTART");
            return TemporalComparator.INSTANCE.compare((LocalDateTime)o1Start.getDate(), (LocalDateTime)o2Start.getDate());
        });
        for (Standard observance : sorted) {
            Optional<TzOffsetFrom> offsetFrom = observance.getTimeZoneOffsetFrom();
            TzOffsetTo offsetTo = (TzOffsetTo)observance.getRequiredProperty("TZOFFSETTO");
            DtStart start = (DtStart)observance.getRequiredProperty("DTSTART");
            if (prevOffset != null && offsetFrom.isPresent() && !offsetTo.getOffset().equals(prevOffset)) {
                transitions.add(ZoneOffsetTransition.of((LocalDateTime)start.getDate(), prevOffset, offsetTo.getOffset()));
            }
            prevOffset = offsetTo.getOffset();
        }
        return transitions;
    }

    private List<ZoneOffsetTransition> buildDSTTransitions(List<Observance> observances) {
        ArrayList<ZoneOffsetTransition> transitions = new ArrayList<ZoneOffsetTransition>();
        for (Observance observance : observances) {
            Optional<TzOffsetFrom> offsetFrom = observance.getTimeZoneOffsetFrom();
            TzOffsetTo offsetTo = (TzOffsetTo)observance.getRequiredProperty("TZOFFSETTO");
            if (!offsetFrom.isPresent() || offsetFrom.get().getOffset().equals(offsetTo.getOffset())) continue;
            DtStart start = (DtStart)observance.getRequiredProperty("DTSTART");
            LocalDateTime periodEnd = LocalDateTime.now();
            if (periodEnd.isBefore((ChronoLocalDateTime)start.getDate())) {
                periodEnd = ((LocalDateTime)start.getDate()).plusYears(5L);
            }
            observance.calculateRecurrenceSet(new Period<LocalDateTime>((LocalDateTime)start.getDate(), periodEnd)).forEach(p -> transitions.add(ZoneOffsetTransition.of((LocalDateTime)p.getStart(), ((TzOffsetFrom)offsetFrom.get()).getOffset(), offsetTo.getOffset())));
        }
        return transitions;
    }

    private List<ZoneOffsetTransitionRule> buildTransitionRules(List<Observance> observances, ZoneOffset standardOffset) throws ConstraintViolationException {
        ArrayList<ZoneOffsetTransitionRule> transitionRules = new ArrayList<ZoneOffsetTransitionRule>();
        for (Observance observance : observances) {
            Optional rrule = observance.getProperty("RRULE");
            TzOffsetFrom offsetFrom = (TzOffsetFrom)observance.getRequiredProperty("TZOFFSETFROM");
            TzOffsetTo offsetTo = (TzOffsetTo)observance.getRequiredProperty("TZOFFSETTO");
            DtStart startDate = (DtStart)observance.getRequiredProperty("DTSTART");
            if (!rrule.isPresent() || ((RRule)rrule.get()).getRecur().getMonthList().isEmpty()) continue;
            Month recurMonth = Month.of(((RRule)rrule.get()).getRecur().getMonthList().get(0).getMonthOfYear());
            int dayOfMonth = ((RRule)rrule.get()).getRecur().getDayList().get(0).getOffset();
            if (dayOfMonth == 0) {
                dayOfMonth = ((RRule)rrule.get()).getRecur().getMonthDayList().get(0);
            }
            DayOfWeek dayOfWeek = WeekDay.getDayOfWeek(((RRule)rrule.get()).getRecur().getDayList().get(0));
            LocalTime time = LocalTime.from(startDate.getDate());
            boolean endOfDay = false;
            ZoneOffsetTransitionRule.TimeDefinition timeDefinition = ZoneOffsetTransitionRule.TimeDefinition.UTC;
            transitionRules.add(ZoneOffsetTransitionRule.of(recurMonth, dayOfMonth, dayOfWeek, time, endOfDay, timeDefinition, standardOffset, offsetFrom.getOffset(), offsetTo.getOffset()));
        }
        return transitionRules;
    }

    public ZoneRules build() throws ConstraintViolationException {
        Instant now = Instant.now();
        Observance currentStandard = VTimeZone.getApplicableObservance(now, this.vTimeZone.getComponents("STANDARD"));
        Observance currentDaylight = VTimeZone.getApplicableObservance(now, this.vTimeZone.getComponents("DAYLIGHT"));
        if (currentStandard == null) {
            currentStandard = currentDaylight;
        }
        TzOffsetFrom offsetFrom = (TzOffsetFrom)currentStandard.getRequiredProperty("TZOFFSETFROM");
        TzOffsetTo offsetTo = (TzOffsetTo)currentStandard.getRequiredProperty("TZOFFSETTO");
        ZoneOffset standardOffset = offsetTo.getOffset();
        ZoneOffset wallOffset = offsetFrom.getOffset();
        List<Standard> stdObservances = this.vTimeZone.getComponents("STANDARD");
        List<ZoneOffsetTransition> standardOffsetTransitions = this.buildStandardOffsetTransitions(stdObservances);
        Collections.sort(standardOffsetTransitions);
        List<ZoneOffsetTransition> offsetTransitions = this.buildDSTTransitions(this.vTimeZone.getObservances());
        Collections.sort(offsetTransitions);
        ArrayList<Observance> latestObservances = new ArrayList<Observance>();
        if (this.vTimeZone.getApplicableObservance(now).equals(currentDaylight)) {
            latestObservances.add(currentStandard);
            latestObservances.add(currentDaylight);
        } else {
            latestObservances.add(currentDaylight);
            latestObservances.add(currentStandard);
        }
        latestObservances = latestObservances.stream().filter(Objects::nonNull).collect(Collectors.toList());
        List<ZoneOffsetTransitionRule> transitionRules = this.buildTransitionRules(latestObservances, standardOffset);
        return ZoneRules.of(standardOffset, wallOffset, standardOffsetTransitions, offsetTransitions, transitionRules);
    }
}

