/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.lang.ref.WeakReference;
import java.time.zone.ZoneRules;
import java.time.zone.ZoneRulesProvider;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import net.fortuna.ical4j.model.TimeZoneRegistry;

public class ZoneRulesProviderImpl
extends ZoneRulesProvider {
    private final WeakReference<TimeZoneRegistry> timeZoneRegistry;

    public ZoneRulesProviderImpl(TimeZoneRegistry timeZoneRegistry) {
        Objects.requireNonNull(timeZoneRegistry, "timeZoneRegistry");
        this.timeZoneRegistry = new WeakReference<TimeZoneRegistry>(timeZoneRegistry);
    }

    @Override
    protected Set<String> provideZoneIds() {
        return Objects.requireNonNull((TimeZoneRegistry)this.timeZoneRegistry.get()).getZoneRules().keySet();
    }

    @Override
    protected ZoneRules provideRules(String zoneId, boolean forCaching) {
        ZoneRules retVal = null;
        if (!forCaching && Objects.requireNonNull((TimeZoneRegistry)this.timeZoneRegistry.get()).getZoneRules().containsKey(zoneId)) {
            retVal = Objects.requireNonNull((TimeZoneRegistry)this.timeZoneRegistry.get()).getZoneRules().get(zoneId);
        }
        return retVal;
    }

    @Override
    protected NavigableMap<String, ZoneRules> provideVersions(String zoneId) {
        TreeMap<String, ZoneRules> retVal = new TreeMap<String, ZoneRules>();
        if (Objects.requireNonNull((TimeZoneRegistry)this.timeZoneRegistry.get()).getZoneRules().containsKey(zoneId)) {
            retVal.put(zoneId, Objects.requireNonNull((TimeZoneRegistry)this.timeZoneRegistry.get()).getZoneRules().get(zoneId));
        }
        return retVal;
    }

    @Override
    protected boolean provideRefresh() {
        return super.provideRefresh();
    }
}

