/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.component;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ConstraintViolationException;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.TemporalAdapter;
import net.fortuna.ical4j.model.TimeZonePropertyAccessor;
import net.fortuna.ical4j.model.property.DateListProperty;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.RRule;
import net.fortuna.ical4j.model.property.TzOffsetFrom;
import net.fortuna.ical4j.model.property.TzOffsetTo;
import net.fortuna.ical4j.util.TimeZones;
import net.fortuna.ical4j.validate.ComponentValidator;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Observance
extends Component
implements TimeZonePropertyAccessor {
    private static final long serialVersionUID = 2523330383042085994L;
    public static final String STANDARD = "STANDARD";
    public static final String DAYLIGHT = "DAYLIGHT";
    private long[] onsetsMillisec;
    private OffsetDateTime[] onsetsDates;
    private OffsetDateTime initialOnset = null;
    private static final String UTC_PATTERN = "yyyyMMdd'T'HHmmss";
    private static final DateFormat UTC_FORMAT = new SimpleDateFormat("yyyyMMdd'T'HHmmss");
    private OffsetDateTime onsetLimit;

    protected Observance(String name) {
        super(name);
    }

    protected Observance(String name, PropertyList properties) {
        super(name, properties);
    }

    @Override
    public ValidationResult validate(boolean recurse) throws ValidationException {
        ValidationResult result = ComponentValidator.OBSERVANCE_ITIP.validate(this);
        if (recurse) {
            result = result.merge(this.validateProperties());
        }
        return result;
    }

    public final OffsetDateTime getLatestOnset(Temporal date) {
        if (!TemporalAdapter.isDateTimePrecision(date)) {
            throw new UnsupportedOperationException("Unable to get timezone observance for date-only temporal.");
        }
        TzOffsetTo offsetTo = (TzOffsetTo)this.getRequiredProperty("TZOFFSETTO");
        TzOffsetFrom offsetFrom = (TzOffsetFrom)this.getRequiredProperty("TZOFFSETFROM");
        OffsetDateTime offsetDate = LocalDateTime.ofInstant(Instant.from(date), ZoneOffset.UTC).atOffset(offsetTo.getOffset());
        if (this.initialOnset == null) {
            try {
                DtStart dtStart = (DtStart)this.getRequiredProperty("DTSTART");
                this.initialOnset = dtStart.getDate().isSupported(ChronoField.HOUR_OF_DAY) ? LocalDateTime.from(dtStart.getDate()).atOffset(offsetFrom.getOffset()) : LocalDate.from(dtStart.getDate()).atStartOfDay().atOffset(offsetFrom.getOffset());
            }
            catch (ConstraintViolationException e) {
                Logger log = LoggerFactory.getLogger(Observance.class);
                log.warn("Unexpected error calculating initial onset - applying default", (Throwable)e);
                this.initialOnset = LocalDateTime.ofEpochSecond(0L, 0, offsetFrom.getOffset()).atOffset(offsetFrom.getOffset());
            }
        }
        if (TemporalAdapter.isBefore(offsetDate, this.initialOnset)) {
            return null;
        }
        if (this.onsetsMillisec != null && (this.onsetLimit == null || TemporalAdapter.isBefore(offsetDate, this.onsetLimit))) {
            return this.getCachedOnset(offsetDate);
        }
        OffsetDateTime onset = this.initialOnset;
        ArrayList<OffsetDateTime> cacheableOnsets = new ArrayList<OffsetDateTime>();
        cacheableOnsets.add(this.initialOnset);
        List rdates = this.getProperties("RDATE");
        for (Object rdate : rdates) {
            List rdateDates = ((DateListProperty)rdate).getDates();
            for (LocalDateTime rdateDate : rdateDates) {
                OffsetDateTime offsetDateTime = OffsetDateTime.from(rdateDate.atOffset(offsetFrom.getOffset()));
                if (!offsetDateTime.isAfter(offsetDate) && offsetDateTime.isAfter(onset)) {
                    onset = offsetDateTime;
                }
                cacheableOnsets.add(offsetDateTime);
            }
        }
        List rrules = this.getProperties("RRULE");
        for (RRule rrule : rrules) {
            this.onsetLimit = offsetDate.plusYears(10L);
            List<OffsetDateTime> recurrenceDates = rrule.getRecur().getDates(this.initialOnset, this.onsetLimit);
            for (Temporal temporal : recurrenceDates) {
                OffsetDateTime rruleOnset = OffsetDateTime.from(temporal).plusSeconds(offsetFrom.getOffset().getTotalSeconds());
                if (!rruleOnset.isAfter(offsetDate) && rruleOnset.isAfter(onset)) {
                    onset = rruleOnset;
                }
                cacheableOnsets.add(rruleOnset);
            }
        }
        Collections.sort(cacheableOnsets);
        this.onsetsMillisec = new long[cacheableOnsets.size()];
        this.onsetsDates = new OffsetDateTime[this.onsetsMillisec.length];
        for (int i = 0; i < this.onsetsMillisec.length; ++i) {
            OffsetDateTime cacheableOnset = (OffsetDateTime)cacheableOnsets.get(i);
            this.onsetsMillisec[i] = cacheableOnset.toInstant().toEpochMilli();
            this.onsetsDates[i] = cacheableOnset;
        }
        return onset;
    }

    private OffsetDateTime getCachedOnset(Temporal date) {
        int index = Arrays.binarySearch(this.onsetsMillisec, Instant.from(date).toEpochMilli());
        if (index >= 0) {
            return this.onsetsDates[index];
        }
        int insertionIndex = -index - 1;
        return this.onsetsDates[insertionIndex - 1];
    }

    static {
        UTC_FORMAT.setTimeZone(TimeZones.getUtcTimeZone());
        UTC_FORMAT.setLenient(false);
    }
}

