/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.component;

import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentContainer;
import net.fortuna.ical4j.model.ComponentFactory;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.DescriptivePropertyAccessor;
import net.fortuna.ical4j.model.LocationsAccessor;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.property.Action;
import net.fortuna.ical4j.model.property.Attach;
import net.fortuna.ical4j.model.property.Duration;
import net.fortuna.ical4j.model.property.Repeat;
import net.fortuna.ical4j.model.property.Trigger;
import net.fortuna.ical4j.validate.ComponentValidator;
import net.fortuna.ical4j.validate.ValidationEntry;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;

public class VAlarm
extends Component
implements ComponentContainer<Component>,
DescriptivePropertyAccessor,
LocationsAccessor {
    private static final long serialVersionUID = -8193965477414653802L;

    public VAlarm() {
        super("VALARM");
    }

    public VAlarm(PropertyList properties) {
        super("VALARM", properties);
    }

    public VAlarm(Instant trigger) {
        this();
        this.add(new Trigger(trigger));
    }

    public VAlarm(TemporalAmount trigger) {
        this();
        this.add(new Trigger(trigger));
    }

    @Override
    public ComponentList<Component> getComponentList() {
        return this.components;
    }

    @Override
    public void setComponentList(ComponentList<Component> components) {
        this.components = components;
    }

    @Override
    public ValidationResult validate(boolean recurse) throws ValidationException {
        ValidationResult result = new ValidationResult(new ValidationEntry[0]);
        if (this.getAction().isPresent()) {
            switch (this.getAction().get().getValue()) {
                case "AUDIO": {
                    result = ComponentValidator.VALARM_AUDIO.validate(this);
                    break;
                }
                case "DISPLAY": {
                    result = ComponentValidator.VALARM_DISPLAY.validate(this);
                    break;
                }
                case "EMAIL": {
                    result = ComponentValidator.VALARM_EMAIL.validate(this);
                }
            }
        } else {
            result = ComponentValidator.VALARM_ITIP.validate(this);
        }
        if (recurse) {
            result = result.merge(this.validateProperties());
        }
        return result;
    }

    @Deprecated
    public final Optional<Action> getAction() {
        return this.getProperty("ACTION");
    }

    @Deprecated
    public final Optional<Trigger> getTrigger() {
        return this.getProperty("TRIGGER");
    }

    @Deprecated
    public final Optional<Duration> getDuration() {
        return this.getProperty("DURATION");
    }

    @Deprecated
    public final Optional<Repeat> getRepeat() {
        return this.getProperty("REPEAT");
    }

    @Deprecated
    public final Optional<Attach> getAttachment() {
        return this.getProperty("ATTACH");
    }

    protected ComponentFactory<VAlarm> newFactory() {
        return new Factory();
    }

    @Override
    public Component copy() {
        return this.newFactory().createComponent(new PropertyList(this.getProperties().parallelStream().map(Property::copy).collect(Collectors.toList())), new ComponentList(this.getComponents(new String[0]).parallelStream().map(Component::copy).collect(Collectors.toList())));
    }

    public static class Factory
    extends Content.Factory
    implements ComponentFactory<VAlarm> {
        public Factory() {
            super("VALARM");
        }

        @Override
        public VAlarm createComponent() {
            return new VAlarm();
        }

        @Override
        public VAlarm createComponent(PropertyList properties) {
            return new VAlarm(properties);
        }
    }
}

