/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.component;

import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fortuna.ical4j.model.AlarmsAccessor;
import net.fortuna.ical4j.model.ChangeManagementPropertyAccessor;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentContainer;
import net.fortuna.ical4j.model.ComponentFactory;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.DateTimePropertyAccessor;
import net.fortuna.ical4j.model.DescriptivePropertyAccessor;
import net.fortuna.ical4j.model.LocationsAccessor;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.ParticipantsAccessor;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.PeriodList;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.Prototype;
import net.fortuna.ical4j.model.RecurrenceSupport;
import net.fortuna.ical4j.model.RelationshipPropertyAccessor;
import net.fortuna.ical4j.model.ResourcesAccessor;
import net.fortuna.ical4j.model.component.CalendarComponent;
import net.fortuna.ical4j.model.component.VAlarm;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStamp;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Duration;
import net.fortuna.ical4j.model.property.Method;
import net.fortuna.ical4j.model.property.RecurrenceId;
import net.fortuna.ical4j.model.property.Status;
import net.fortuna.ical4j.model.property.Summary;
import net.fortuna.ical4j.model.property.Transp;
import net.fortuna.ical4j.model.property.immutable.ImmutableMethod;
import net.fortuna.ical4j.model.property.immutable.ImmutableStatus;
import net.fortuna.ical4j.model.property.immutable.ImmutableTransp;
import net.fortuna.ical4j.util.CompatibilityHints;
import net.fortuna.ical4j.validate.ComponentValidator;
import net.fortuna.ical4j.validate.ValidationEntry;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.validate.ValidationRule;
import net.fortuna.ical4j.validate.Validator;
import net.fortuna.ical4j.validate.component.VEventValidator;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class VEvent
extends CalendarComponent
implements ComponentContainer<Component>,
RecurrenceSupport<VEvent>,
DescriptivePropertyAccessor,
ChangeManagementPropertyAccessor,
DateTimePropertyAccessor,
RelationshipPropertyAccessor,
AlarmsAccessor,
ParticipantsAccessor,
LocationsAccessor,
ResourcesAccessor {
    private static final long serialVersionUID = 2547948989200697335L;
    private static final Map<Method, Validator<VEvent>> methodValidators = new HashMap<Method, Validator<VEvent>>();

    public VEvent() {
        this(true);
    }

    public VEvent(boolean initialise) {
        super("VEVENT");
        if (initialise) {
            this.add(new DtStamp());
        }
    }

    public VEvent(PropertyList properties) {
        super("VEVENT", properties);
    }

    public VEvent(PropertyList properties, ComponentList<VAlarm> alarms) {
        super("VEVENT", properties, alarms);
    }

    public VEvent(Temporal start, String summary) {
        this();
        this.add(new DtStart<Temporal>(start));
        this.add(new Summary(summary));
    }

    public VEvent(Temporal start, Temporal end, String summary) {
        this();
        this.add(new DtStart<Temporal>(start));
        this.add(new DtEnd<Temporal>(end));
        this.add(new Summary(summary));
    }

    public VEvent(Temporal start, TemporalAmount duration, String summary) {
        this();
        this.add(new DtStart<Temporal>(start));
        this.add(new Duration(duration));
        this.add(new Summary(summary));
    }

    @Override
    public ComponentList<Component> getComponentList() {
        return this.components;
    }

    @Override
    public void setComponentList(ComponentList<Component> components) {
        this.components = components;
    }

    @Override
    public ValidationResult validate(boolean recurse) throws ValidationException {
        ValidationResult result = ComponentValidator.VEVENT.validate(this);
        Optional<Status> status = this.getStatus();
        if (status.isPresent() && !ImmutableStatus.VEVENT_TENTATIVE.getValue().equals(status.get().getValue()) && !ImmutableStatus.VEVENT_CONFIRMED.getValue().equals(status.get().getValue()) && !ImmutableStatus.VEVENT_CANCELLED.getValue().equals(status.get().getValue())) {
            result.getEntries().add(new ValidationEntry("Status property [" + status + "] is not applicable for VEVENT", ValidationEntry.Severity.ERROR, this.getName()));
        }
        if (this.getDateTimeEnd().isPresent()) {
            Optional start = this.getDateTimeStart();
            Optional end = this.getDateTimeEnd();
            if (start.isPresent()) {
                Optional startValue = start.get().getParameter("VALUE");
                Optional endValue = end.get().getParameter("VALUE");
                boolean startEndValueMismatch = false;
                if (endValue.isPresent()) {
                    if (startValue.isPresent() && !endValue.equals(startValue)) {
                        startEndValueMismatch = true;
                    } else if (!startValue.isPresent() && !Value.DATE_TIME.equals(endValue.get())) {
                        startEndValueMismatch = true;
                    }
                } else if (startValue.isPresent() && !Value.DATE_TIME.equals(startValue.get())) {
                    startEndValueMismatch = true;
                }
                if (startEndValueMismatch) {
                    result.getEntries().add(new ValidationEntry("Property [DTEND] must have the same [VALUE] as [DTSTART]", ValidationEntry.Severity.ERROR, this.getName()));
                }
            }
        }
        if (recurse) {
            result = result.merge(this.validateProperties());
        }
        return result;
    }

    @Override
    public ValidationResult validate(Method method) throws ValidationException {
        Validator<VEvent> validator = methodValidators.get(method);
        if (validator != null) {
            return validator.validate(this);
        }
        return super.validate(method);
    }

    public final <T extends Temporal> List<Period<T>> getConsumedTime(Period<T> range) {
        return this.getConsumedTime(range, true);
    }

    public final <T extends Temporal> List<Period<T>> getConsumedTime(Period<T> range, boolean normalise) {
        PeriodList periods;
        Optional<Transp> transp = this.getTimeTransparency();
        if (transp.isEmpty() || !ImmutableTransp.TRANSPARENT.equals(transp.get())) {
            periods = new PeriodList(this.calculateRecurrenceSet(range));
            if (!periods.getPeriods().isEmpty() && normalise) {
                periods = periods.normalise();
            }
        } else {
            periods = new PeriodList();
        }
        return new ArrayList(periods.getPeriods());
    }

    @Deprecated
    public final <T extends Temporal> VEvent getOccurrence(T date) {
        List<Period<T>> consumedTime = this.getConsumedTime(new Period<T>(date, date));
        for (Period<T> p : consumedTime) {
            if (!p.getStart().equals(date)) continue;
            VEvent occurrence = (VEvent)this.copy();
            occurrence.add(new RecurrenceId<T>(date));
            return occurrence;
        }
        return null;
    }

    @Deprecated
    public final <T extends Temporal> Optional<DtStart<T>> getStartDate() {
        return this.getDateTimeStart();
    }

    @Deprecated
    public final Optional<DtStamp> getDateStamp() {
        return this.getDateTimeStamp();
    }

    @Deprecated
    public final Optional<Transp> getTransparency() {
        return this.getTimeTransparency();
    }

    public final <T extends Temporal> Optional<DtEnd<T>> getEndDate() {
        return this.getEndDate(true);
    }

    public final <T extends Temporal> Optional<DtEnd<T>> getEndDate(boolean deriveFromDuration) {
        Optional dtStart;
        Optional dtEnd = this.getDateTimeEnd();
        if (dtEnd.isEmpty() && deriveFromDuration && (dtStart = this.getDateTimeStart()).isPresent()) {
            DtEnd<Temporal> newdtEnd;
            Optional<Duration> duration = this.getDuration();
            Duration vEventDuration = duration.isPresent() ? duration.get() : (dtStart.get().getParameter("VALUE").equals(Optional.of(Value.DATE_TIME)) ? new Duration(java.time.Duration.ZERO) : new Duration(java.time.Duration.ofDays(1L)));
            Optional tzId = dtStart.get().getParameter("TZID");
            if (tzId.isPresent()) {
                ParameterList dtendParams = new ParameterList(Collections.singletonList((Parameter)tzId.get()));
                newdtEnd = new DtEnd<Temporal>(dtendParams, dtStart.get().getDate().plus(vEventDuration.getDuration()));
            } else {
                newdtEnd = new DtEnd<Temporal>(dtStart.get().getDate().plus(vEventDuration.getDuration()));
            }
            return Optional.of(newdtEnd);
        }
        return dtEnd;
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 instanceof VEvent) {
            return super.equals(arg0) && Objects.equals(this.getAlarms(), ((VEvent)arg0).getAlarms());
        }
        return super.equals(arg0);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getName()).append(this.getProperties()).append(this.getAlarms()).toHashCode();
    }

    protected ComponentFactory<VEvent> newFactory() {
        return new Factory();
    }

    @Override
    public Component copy() {
        return this.newFactory().createComponent(new PropertyList(this.getProperties().parallelStream().map(Prototype::copy).collect(Collectors.toList())), new ComponentList(this.getComponents(new String[0]).parallelStream().map(Prototype::copy).collect(Collectors.toList())));
    }

    static {
        methodValidators.put(ImmutableMethod.ADD, new VEventValidator(new ValidationRule(ValidationRule.ValidationType.One, "DTSTAMP", "DTSTART", "ORGANIZER", "SEQUENCE", "SUMMARY", "UID"), new ValidationRule(ValidationRule.ValidationType.OneOrLess, "CATEGORIES", "CLASS", "CREATED", "DESCRIPTION", "DTEND", "DURATION", "GEO", "LAST-MODIFIED", "LOCATION", "PRIORITY", "RESOURCES", "STATUS", "TRANSP", "URL"), new ValidationRule(ValidationRule.ValidationType.None, "RECURRENCE-ID", "REQUEST-STATUS")));
        methodValidators.put(ImmutableMethod.CANCEL, new VEventValidator(false, new ValidationRule(ValidationRule.ValidationType.One, "DTSTAMP", "DTSTART", "ORGANIZER", "SEQUENCE", "UID"), new ValidationRule(ValidationRule.ValidationType.OneOrLess, "CATEGORIES", "CLASS", "CREATED", "DESCRIPTION", "DTEND", "DTSTART", "DURATION", "GEO", "LAST-MODIFIED", "LOCATION", "PRIORITY", "RECURRENCE-ID", "RESOURCES", "STATUS", "SUMMARY", "TRANSP", "URL"), new ValidationRule(ValidationRule.ValidationType.None, "REQUEST-STATUS")));
        methodValidators.put(ImmutableMethod.COUNTER, new VEventValidator(new ValidationRule(ValidationRule.ValidationType.One, "DTSTAMP", "DTSTART", "SEQUENCE", "SUMMARY", "UID"), new ValidationRule(ValidationRule.ValidationType.One, true, "ORGANIZER"), new ValidationRule(ValidationRule.ValidationType.OneOrLess, "CATEGORIES", "CLASS", "CREATED", "DESCRIPTION", "DTEND", "DURATION", "GEO", "LAST-MODIFIED", "LOCATION", "PRIORITY", "RECURRENCE-ID", "RESOURCES", "STATUS", "TRANSP", "URL")));
        methodValidators.put(ImmutableMethod.DECLINE_COUNTER, new VEventValidator(false, new ValidationRule(ValidationRule.ValidationType.One, "DTSTAMP", "ORGANIZER", "UID"), new ValidationRule(ValidationRule.ValidationType.OneOrLess, "RECURRENCE-ID", "SEQUENCE"), new ValidationRule(ValidationRule.ValidationType.None, "ATTACH", "ATTENDEE", "CATEGORIES", "CLASS", "CONTACT", "CREATED", "DESCRIPTION", "DTEND", "DTSTART", "DURATION", "EXDATE", "EXRULE", "GEO", "LAST-MODIFIED", "LOCATION", "PRIORITY", "RDATE", "RELATED-TO", "RESOURCES", "RRULE", "STATUS", "SUMMARY", "TRANSP", "URL")));
        methodValidators.put(ImmutableMethod.PUBLISH, new VEventValidator(new ValidationRule(ValidationRule.ValidationType.One, "DTSTART", "UID"), new ValidationRule(ValidationRule.ValidationType.One, true, "DTSTAMP", "ORGANIZER", "SUMMARY"), new ValidationRule(ValidationRule.ValidationType.OneOrLess, "RECURRENCE-ID", "SEQUENCE", "CATEGORIES", "CLASS", "CREATED", "DESCRIPTION", "DTEND", "DURATION", "GEO", "LAST-MODIFIED", "LOCATION", "PRIORITY", "RESOURCES", "STATUS", "TRANSP", "URL"), new ValidationRule(ValidationRule.ValidationType.None, true, "ATTENDEE"), new ValidationRule(ValidationRule.ValidationType.None, "REQUEST-STATUS")));
        methodValidators.put(ImmutableMethod.REFRESH, new VEventValidator(false, new ValidationRule(ValidationRule.ValidationType.One, "ATTENDEE", "DTSTAMP", "ORGANIZER", "UID"), new ValidationRule(ValidationRule.ValidationType.OneOrLess, "RECURRENCE-ID"), new ValidationRule(ValidationRule.ValidationType.None, "ATTACH", "CATEGORIES", "CLASS", "CONTACT", "CREATED", "DESCRIPTION", "DTEND", "DTSTART", "DURATION", "EXDATE", "EXRULE", "GEO", "LAST-MODIFIED", "LOCATION", "PRIORITY", "RDATE", "RELATED-TO", "REQUEST-STATUS", "RESOURCES", "RRULE", "SEQUENCE", "STATUS", "SUMMARY", "TRANSP", "URL")));
        methodValidators.put(ImmutableMethod.REPLY, new VEventValidator(CompatibilityHints.isHintEnabled("ical4j.validation.relaxed"), new ValidationRule(ValidationRule.ValidationType.One, "ATTENDEE", "DTSTAMP", "ORGANIZER", "UID"), new ValidationRule(ValidationRule.ValidationType.OneOrLess, "RECURRENCE-ID", "SEQUENCE", "CATEGORIES", "CLASS", "CREATED", "DESCRIPTION", "DTEND", "DTSTART", "DURATION", "GEO", "LAST-MODIFIED", "LOCATION", "PRIORITY", "RESOURCES", "STATUS", "SUMMARY", "TRANSP", "URL")));
        methodValidators.put(ImmutableMethod.REQUEST, new VEventValidator(new ValidationRule(ValidationRule.ValidationType.OneOrMore, true, "ATTENDEE"), new ValidationRule(ValidationRule.ValidationType.One, "DTSTAMP", "DTSTART", "ORGANIZER", "SUMMARY", "UID"), new ValidationRule(ValidationRule.ValidationType.OneOrLess, "SEQUENCE", "CATEGORIES", "CLASS", "CREATED", "DESCRIPTION", "DTEND", "DURATION", "GEO", "LAST-MODIFIED", "LOCATION", "PRIORITY", "RECURRENCE-ID", "RESOURCES", "STATUS", "TRANSP", "URL")));
    }

    public static class Factory
    extends Content.Factory
    implements ComponentFactory<VEvent> {
        public Factory() {
            super("VEVENT");
        }

        @Override
        public VEvent createComponent() {
            return new VEvent(false);
        }

        @Override
        public VEvent createComponent(PropertyList properties) {
            return new VEvent(properties);
        }

        @Override
        public VEvent createComponent(PropertyList properties, ComponentList<?> subComponents) {
            return new VEvent(properties, subComponents);
        }
    }
}

