/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.component;

import java.time.Instant;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentContainer;
import net.fortuna.ical4j.model.ComponentFactory;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.DateTimePropertyAccessor;
import net.fortuna.ical4j.model.LocationsAccessor;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.ParticipantsAccessor;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.PeriodList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.ResourcesAccessor;
import net.fortuna.ical4j.model.TemporalAdapter;
import net.fortuna.ical4j.model.TemporalAmountComparator;
import net.fortuna.ical4j.model.component.CalendarComponent;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.parameter.FbType;
import net.fortuna.ical4j.model.property.Contact;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStamp;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Duration;
import net.fortuna.ical4j.model.property.FreeBusy;
import net.fortuna.ical4j.model.property.Method;
import net.fortuna.ical4j.model.property.Organizer;
import net.fortuna.ical4j.model.property.Url;
import net.fortuna.ical4j.model.property.immutable.ImmutableMethod;
import net.fortuna.ical4j.validate.ComponentValidator;
import net.fortuna.ical4j.validate.ValidationEntry;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.validate.ValidationRule;
import net.fortuna.ical4j.validate.Validator;
import org.threeten.extra.Interval;

public class VFreeBusy
extends CalendarComponent
implements ComponentContainer<Component>,
ParticipantsAccessor,
LocationsAccessor,
ResourcesAccessor,
DateTimePropertyAccessor {
    private static final long serialVersionUID = 1046534053331139832L;
    private static final Map<Method, Validator<VFreeBusy>> methodValidators = new HashMap<Method, Validator<VFreeBusy>>();

    public VFreeBusy() {
        this(true);
    }

    public VFreeBusy(boolean initialise) {
        super("VFREEBUSY");
        if (initialise) {
            this.add(new DtStamp());
        }
    }

    public VFreeBusy(PropertyList properties) {
        super("VFREEBUSY", properties);
    }

    public VFreeBusy(Temporal start, Temporal end) {
        this();
        this.add(new DtStart<Temporal>(start));
        this.add(new DtEnd<Temporal>(end));
    }

    public VFreeBusy(Instant start, Instant end, TemporalAmount duration) {
        this();
        this.add(new DtStart<Instant>(start));
        this.add(new DtEnd<Instant>(end));
        this.add(new Duration(duration));
    }

    public VFreeBusy(VFreeBusy request, List<CalendarComponent> components) {
        this();
        FreeBusy fb;
        DtStart start = (DtStart)request.getRequiredProperty("DTSTART");
        DtEnd end = (DtEnd)request.getRequiredProperty("DTEND");
        request.validate();
        Optional<Duration> duration = request.getDuration();
        this.add(new DtStart(start.getDate()));
        this.add(new DtEnd(end.getDate()));
        Instant fbStart = Instant.from(start.getDate());
        Instant fbEnd = Instant.from(end.getDate());
        if (duration.isPresent()) {
            this.add(new Duration(duration.get().getDuration()));
            fb = new FreeTimeBuilder().start(fbStart).end(fbEnd).duration(duration.get().getDuration()).components(components).build();
        } else {
            fb = new BusyTimeBuilder().start(fbStart).end(fbEnd).components(components).build();
        }
        if (!fb.getIntervals().isEmpty()) {
            this.add(fb);
        }
    }

    private static <T extends Temporal> List<Interval> getConsumedTime(List<CalendarComponent> components, Period<T> range) {
        ArrayList periods = new ArrayList();
        components.stream().filter(c -> c.getName().equals("VEVENT")).forEach(c -> periods.addAll(((VEvent)c).getConsumedTime(range, false)));
        return new PeriodList(periods).normalise().getPeriods().stream().map(Period::toInterval).collect(Collectors.toList());
    }

    @Override
    public ValidationResult validate(boolean recurse) throws ValidationException {
        ValidationResult result = ComponentValidator.VFREEBUSY.validate(this);
        Optional dtStart = this.getDateTimeStart();
        Optional dtEnd = this.getDateTimeEnd();
        if (dtStart.isPresent() && dtEnd.isPresent() && TemporalAdapter.isBefore(dtStart.get().getDate(), dtEnd.get().getDate())) {
            result.getEntries().add(new ValidationEntry("Property [DTEND] must be later in time than [DTSTART]", ValidationEntry.Severity.ERROR, this.getName()));
        }
        if (recurse) {
            result = result.merge(this.validateProperties());
        }
        return result;
    }

    @Override
    public ValidationResult validate(Method method) throws ValidationException {
        Validator<VFreeBusy> validator = methodValidators.get(method);
        if (validator != null) {
            return validator.validate(this);
        }
        return super.validate(method);
    }

    @Override
    public ComponentList<Component> getComponentList() {
        return this.components;
    }

    @Override
    public void setComponentList(ComponentList<Component> components) {
        this.components = components;
    }

    @Deprecated
    public final Optional<Contact> getContact() {
        return this.getProperty("CONTACT");
    }

    @Deprecated
    public final <T extends Temporal> Optional<DtStart<T>> getStartDate() {
        return this.getDateTimeStart();
    }

    @Deprecated
    public final <T extends Temporal> Optional<DtEnd<T>> getEndDate() {
        return this.getDateTimeEnd();
    }

    @Deprecated
    public final Optional<DtStamp> getDateStamp() {
        return this.getProperty("DTSTAMP");
    }

    @Deprecated
    public final Optional<Organizer> getOrganizer() {
        return this.getProperty("ORGANIZER");
    }

    @Deprecated
    public final Optional<Url> getUrl() {
        return this.getProperty("URL");
    }

    protected ComponentFactory<VFreeBusy> newFactory() {
        return new Factory();
    }

    @Override
    public Component copy() {
        return this.newFactory().createComponent(new PropertyList(this.getProperties().parallelStream().map(Property::copy).collect(Collectors.toList())), new ComponentList(this.getComponents(new String[0]).parallelStream().map(Component::copy).collect(Collectors.toList())));
    }

    static {
        methodValidators.put(ImmutableMethod.PUBLISH, new ComponentValidator("VFREEBUSY", new ValidationRule(ValidationRule.ValidationType.OneOrMore, "FREEBUSY"), new ValidationRule(ValidationRule.ValidationType.One, "DTSTAMP", "DTSTART", "DTEND", "ORGANIZER", "UID"), new ValidationRule(ValidationRule.ValidationType.OneOrLess, "URL"), new ValidationRule(ValidationRule.ValidationType.None, "ATTENDEE", "DURATION", "REQUEST-STATUS")));
        methodValidators.put(ImmutableMethod.REPLY, new ComponentValidator("VFREEBUSY", new ValidationRule(ValidationRule.ValidationType.One, "ATTENDEE", "DTSTAMP", "DTEND", "DTSTART", "ORGANIZER", "UID"), new ValidationRule(ValidationRule.ValidationType.OneOrLess, "URL"), new ValidationRule(ValidationRule.ValidationType.None, "DURATION", "SEQUENCE")));
        methodValidators.put(ImmutableMethod.REQUEST, new ComponentValidator("VFREEBUSY", new ValidationRule(ValidationRule.ValidationType.OneOrMore, "ATTENDEE"), new ValidationRule(ValidationRule.ValidationType.One, "DTEND", "DTSTAMP", "DTSTART", "ORGANIZER", "UID"), new ValidationRule(ValidationRule.ValidationType.None, "FREEBUSY", "DURATION", "REQUEST-STATUS", "URL")));
    }

    private static class FreeTimeBuilder {
        private Instant start;
        private Instant end;
        private TemporalAmount duration;
        private List<CalendarComponent> components;

        private FreeTimeBuilder() {
        }

        public FreeTimeBuilder start(Instant start) {
            this.start = start;
            return this;
        }

        public FreeTimeBuilder end(Instant end) {
            this.end = end;
            return this;
        }

        private FreeTimeBuilder duration(TemporalAmount duration) {
            this.duration = duration;
            return this;
        }

        public FreeTimeBuilder components(List<CalendarComponent> components) {
            this.components = components;
            return this;
        }

        public FreeBusy build() {
            List<Interval> periods = VFreeBusy.getConsumedTime(this.components, new Period<Instant>(this.start, this.end));
            Interval interval = Interval.of((Instant)this.start, (Instant)this.end);
            periods.add(Interval.of((Instant)this.end, (Instant)this.end));
            Instant lastPeriodEnd = this.start;
            ArrayList<Interval> freePeriods = new ArrayList<Interval>();
            for (Interval period : periods) {
                Duration freeDuration;
                if ((interval.encloses(period) || interval.overlaps(period) && Instant.from(period.getStart()).isAfter(Instant.from(interval.getStart()))) && new TemporalAmountComparator().compare((freeDuration = new Duration(lastPeriodEnd, period.getStart())).getDuration(), this.duration) >= 0) {
                    freePeriods.add(Interval.of((Instant)lastPeriodEnd, (java.time.Duration)((java.time.Duration)freeDuration.getDuration())));
                }
                if (!Instant.from(period.getEnd()).isAfter(lastPeriodEnd)) continue;
                lastPeriodEnd = Instant.from(period.getEnd());
            }
            ParameterList fbParams = new ParameterList(Collections.singletonList(FbType.FREE));
            return new FreeBusy(fbParams, freePeriods);
        }
    }

    private static class BusyTimeBuilder {
        private Instant start;
        private Instant end;
        private List<CalendarComponent> components;

        private BusyTimeBuilder() {
        }

        public BusyTimeBuilder start(Instant start) {
            this.start = start;
            return this;
        }

        public BusyTimeBuilder end(Instant end) {
            this.end = end;
            return this;
        }

        public BusyTimeBuilder components(List<CalendarComponent> components) {
            this.components = components;
            return this;
        }

        public FreeBusy build() {
            List<Interval> periods = VFreeBusy.getConsumedTime(this.components, new Period<Instant>(this.start, this.end));
            periods.removeIf(period -> !period.overlaps(Interval.of((Instant)this.start, (Instant)this.end)));
            return new FreeBusy(periods);
        }
    }

    public static class Factory
    extends Content.Factory
    implements ComponentFactory<VFreeBusy> {
        public Factory() {
            super("VFREEBUSY");
        }

        @Override
        public VFreeBusy createComponent() {
            return new VFreeBusy(false);
        }

        @Override
        public VFreeBusy createComponent(PropertyList properties) {
            return new VFreeBusy(properties);
        }
    }
}

