/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.component;

import java.time.temporal.Temporal;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fortuna.ical4j.model.ChangeManagementPropertyAccessor;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentContainer;
import net.fortuna.ical4j.model.ComponentFactory;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.DateTimePropertyAccessor;
import net.fortuna.ical4j.model.DescriptivePropertyAccessor;
import net.fortuna.ical4j.model.LocationsAccessor;
import net.fortuna.ical4j.model.ParticipantsAccessor;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.RecurrenceSupport;
import net.fortuna.ical4j.model.RelationshipPropertyAccessor;
import net.fortuna.ical4j.model.ResourcesAccessor;
import net.fortuna.ical4j.model.component.CalendarComponent;
import net.fortuna.ical4j.model.property.DtStamp;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Method;
import net.fortuna.ical4j.model.property.Summary;
import net.fortuna.ical4j.model.property.immutable.ImmutableMethod;
import net.fortuna.ical4j.validate.ComponentValidator;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.validate.ValidationRule;
import net.fortuna.ical4j.validate.Validator;

public class VJournal
extends CalendarComponent
implements ComponentContainer<Component>,
RecurrenceSupport<VJournal>,
DescriptivePropertyAccessor,
ChangeManagementPropertyAccessor,
DateTimePropertyAccessor,
RelationshipPropertyAccessor,
ParticipantsAccessor,
LocationsAccessor,
ResourcesAccessor {
    private static final long serialVersionUID = -7635140949183238830L;
    private static final Map<Method, Validator<VJournal>> methodValidators = new HashMap<Method, Validator<VJournal>>();

    public VJournal() {
        this(true);
    }

    public VJournal(boolean initialise) {
        super("VJOURNAL");
        if (initialise) {
            this.add(new DtStamp());
        }
    }

    public VJournal(PropertyList properties) {
        super("VJOURNAL", properties);
    }

    public VJournal(Temporal start, String summary) {
        this();
        this.add(new DtStart<Temporal>(start));
        this.add(new Summary(summary));
    }

    @Override
    public ValidationResult validate(boolean recurse) throws ValidationException {
        ValidationResult result = ComponentValidator.VJOURNAL.validate(this);
        if (recurse) {
            result = result.merge(this.validateProperties());
        }
        return result;
    }

    @Override
    public ValidationResult validate(Method method) throws ValidationException {
        Validator<VJournal> validator = methodValidators.get(method);
        if (validator != null) {
            return validator.validate(this);
        }
        return super.validate(method);
    }

    @Override
    public ComponentList<Component> getComponentList() {
        return this.components;
    }

    @Override
    public void setComponentList(ComponentList<Component> components) {
        this.components = components;
    }

    @Deprecated
    public final <T extends Temporal> Optional<DtStart<T>> getStartDate() {
        return this.getDateTimeStart();
    }

    @Deprecated
    public final Optional<DtStamp> getDateStamp() {
        return this.getDateTimeStamp();
    }

    protected ComponentFactory<VJournal> newFactory() {
        return new Factory();
    }

    @Override
    public Component copy() {
        return this.newFactory().createComponent(new PropertyList(this.getProperties().parallelStream().map(Property::copy).collect(Collectors.toList())), new ComponentList(this.getComponents(new String[0]).parallelStream().map(Component::copy).collect(Collectors.toList())));
    }

    static {
        methodValidators.put(ImmutableMethod.ADD, new ComponentValidator("VJOURNAL", new ValidationRule(ValidationRule.ValidationType.One, "DESCRIPTION", "DTSTAMP", "DTSTART", "ORGANIZER", "SEQUENCE", "UID"), new ValidationRule(ValidationRule.ValidationType.OneOrLess, "CATEGORIES", "CLASS", "CREATED", "LAST-MODIFIED", "STATUS", "SUMMARY", "URL"), new ValidationRule(ValidationRule.ValidationType.None, "ATTENDEE", "RECURRENCE-ID")));
        methodValidators.put(ImmutableMethod.CANCEL, new ComponentValidator("VJOURNAL", new ValidationRule(ValidationRule.ValidationType.One, "DTSTAMP", "ORGANIZER", "SEQUENCE", "UID"), new ValidationRule(ValidationRule.ValidationType.OneOrLess, "CATEGORIES", "CLASS", "CREATED", "DESCRIPTION", "DTSTART", "LAST-MODIFIED", "RECURRENCE-ID", "STATUS", "SUMMARY", "URL"), new ValidationRule(ValidationRule.ValidationType.None, "REQUEST-STATUS")));
        methodValidators.put(ImmutableMethod.PUBLISH, new ComponentValidator("VJOURNAL", new ValidationRule(ValidationRule.ValidationType.One, "DESCRIPTION", "DTSTAMP", "DTSTART", "ORGANIZER", "UID"), new ValidationRule(ValidationRule.ValidationType.OneOrLess, "CATEGORIES", "CLASS", "CREATED", "LAST-MODIFIED", "RECURRENCE-ID", "SEQUENCE", "STATUS", "SUMMARY", "URL"), new ValidationRule(ValidationRule.ValidationType.None, "ATTENDEE")));
    }

    public static class Factory
    extends Content.Factory
    implements ComponentFactory<VJournal> {
        public Factory() {
            super("VJOURNAL");
        }

        @Override
        public VJournal createComponent() {
            return new VJournal(false);
        }

        @Override
        public VJournal createComponent(PropertyList properties) {
            return new VJournal(properties);
        }
    }
}

