/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.component;

import java.time.OffsetDateTime;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentContainer;
import net.fortuna.ical4j.model.ComponentFactory;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.TimeZonePropertyAccessor;
import net.fortuna.ical4j.model.component.CalendarComponent;
import net.fortuna.ical4j.model.component.Observance;
import net.fortuna.ical4j.model.property.Method;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.validate.Validator;
import net.fortuna.ical4j.validate.component.VTimeZoneValidator;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class VTimeZone
extends CalendarComponent
implements ComponentContainer<Observance>,
TimeZonePropertyAccessor {
    private static final long serialVersionUID = 5629679741050917815L;
    private static final Validator<VTimeZone> itipValidator = new VTimeZoneValidator();

    public VTimeZone() {
        super("VTIMEZONE");
    }

    public VTimeZone(PropertyList properties) {
        super("VTIMEZONE", properties);
    }

    public VTimeZone(ComponentList<Observance> observances) {
        this(new PropertyList(), observances);
    }

    public VTimeZone(PropertyList properties, ComponentList<Observance> observances) {
        super("VTIMEZONE", properties, observances);
    }

    @Override
    public ValidationResult validate(boolean recurse) throws ValidationException {
        ValidationResult result = new VTimeZoneValidator().validate(this);
        if (recurse) {
            result = result.merge(this.validateProperties());
        }
        return result;
    }

    @Override
    public ValidationResult validate(Method method) throws ValidationException {
        return itipValidator.validate(this);
    }

    public final List<Observance> getObservances() {
        return this.components.get("STANDARD", "DAYLIGHT");
    }

    @Override
    public ComponentList<Observance> getComponentList() {
        return this.components;
    }

    @Override
    public void setComponentList(ComponentList<Observance> components) {
        this.components = components;
    }

    public final Observance getApplicableObservance(Temporal date) {
        return VTimeZone.getApplicableObservance(date, this.getObservances());
    }

    public static Observance getApplicableObservance(Temporal date, List<Observance> observances) {
        Observance latestObservance = null;
        OffsetDateTime latestOnset = null;
        for (Observance observance : observances) {
            OffsetDateTime onset = observance.getLatestOnset(date);
            if (latestOnset != null && (onset == null || !onset.isAfter(latestOnset))) continue;
            latestOnset = onset;
            latestObservance = observance;
        }
        return latestObservance;
    }

    @Override
    public Component copy() {
        return this.newFactory().createComponent(new PropertyList(this.getProperties().parallelStream().map(Property::copy).collect(Collectors.toList())), new ComponentList(this.getComponents(new String[0]).parallelStream().map(Component::copy).collect(Collectors.toList())));
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 instanceof VTimeZone) {
            return super.equals(arg0) && Objects.equals(this.getObservances(), ((VTimeZone)arg0).getObservances());
        }
        return super.equals(arg0);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getName()).append(this.getProperties()).append(this.getObservances()).toHashCode();
    }

    protected ComponentFactory<VTimeZone> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements ComponentFactory<VTimeZone> {
        public Factory() {
            super("VTIMEZONE");
        }

        @Override
        public VTimeZone createComponent() {
            return new VTimeZone();
        }

        @Override
        public VTimeZone createComponent(PropertyList properties) {
            return new VTimeZone(properties);
        }

        @Override
        public VTimeZone createComponent(PropertyList properties, ComponentList<?> subComponents) {
            return new VTimeZone(properties, subComponents);
        }
    }
}

