/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.component;

import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fortuna.ical4j.model.AlarmsAccessor;
import net.fortuna.ical4j.model.ChangeManagementPropertyAccessor;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentContainer;
import net.fortuna.ical4j.model.ComponentFactory;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.DateTimePropertyAccessor;
import net.fortuna.ical4j.model.DescriptivePropertyAccessor;
import net.fortuna.ical4j.model.LocationsAccessor;
import net.fortuna.ical4j.model.ParticipantsAccessor;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.RecurrenceSupport;
import net.fortuna.ical4j.model.RelationshipPropertyAccessor;
import net.fortuna.ical4j.model.ResourcesAccessor;
import net.fortuna.ical4j.model.component.CalendarComponent;
import net.fortuna.ical4j.model.component.VAlarm;
import net.fortuna.ical4j.model.property.Completed;
import net.fortuna.ical4j.model.property.DtStamp;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Due;
import net.fortuna.ical4j.model.property.Duration;
import net.fortuna.ical4j.model.property.Method;
import net.fortuna.ical4j.model.property.Status;
import net.fortuna.ical4j.model.property.Summary;
import net.fortuna.ical4j.model.property.immutable.ImmutableMethod;
import net.fortuna.ical4j.model.property.immutable.ImmutableStatus;
import net.fortuna.ical4j.validate.ComponentValidator;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.validate.ValidationRule;
import net.fortuna.ical4j.validate.Validator;
import net.fortuna.ical4j.validate.component.VToDoValidator;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class VToDo
extends CalendarComponent
implements ComponentContainer<Component>,
RecurrenceSupport<VToDo>,
DescriptivePropertyAccessor,
ChangeManagementPropertyAccessor,
DateTimePropertyAccessor,
RelationshipPropertyAccessor,
AlarmsAccessor,
ParticipantsAccessor,
LocationsAccessor,
ResourcesAccessor {
    private static final long serialVersionUID = -269658210065896668L;
    private static final Map<Method, Validator<VToDo>> methodValidators = new HashMap<Method, Validator<VToDo>>();

    public VToDo() {
        this(true);
    }

    public VToDo(boolean initialise) {
        super("VTODO");
        if (initialise) {
            this.add(new DtStamp());
        }
    }

    public VToDo(PropertyList properties) {
        super("VTODO", properties);
    }

    public VToDo(PropertyList properties, ComponentList<VAlarm> alarms) {
        super("VTODO", properties, alarms);
    }

    public VToDo(Temporal start, String summary) {
        this();
        this.add(new DtStart<Temporal>(start));
        this.add(new Summary(summary));
    }

    public VToDo(Temporal start, Temporal due, String summary) {
        this();
        this.add(new DtStart<Temporal>(start));
        this.add(new Due<Temporal>(due));
        this.add(new Summary(summary));
    }

    public VToDo(Temporal start, TemporalAmount duration, String summary) {
        this();
        this.add(new DtStart<Temporal>(start));
        this.add(new Duration(duration));
        this.add(new Summary(summary));
    }

    @Override
    public ComponentList<Component> getComponentList() {
        return this.components;
    }

    @Override
    public void setComponentList(ComponentList<Component> components) {
        this.components = components;
    }

    @Override
    public ValidationResult validate(boolean recurse) throws ValidationException {
        ValidationResult result = ComponentValidator.VTODO.validate(this);
        for (VAlarm component : this.getAlarms()) {
            component.validate(recurse);
        }
        Optional<Status> status = this.getStatus();
        if (!(!status.isPresent() || ImmutableStatus.VTODO_NEEDS_ACTION.equals(status.get()) || ImmutableStatus.VTODO_COMPLETED.equals(status.get()) || ImmutableStatus.VTODO_IN_PROCESS.equals(status.get()) || ImmutableStatus.VTODO_CANCELLED.equals(status.get()))) {
            throw new ValidationException("Status property [" + status + "] may not occur in VTODO");
        }
        if (recurse) {
            result = result.merge(this.validateProperties());
        }
        return result;
    }

    @Override
    public ValidationResult validate(Method method) throws ValidationException {
        Validator<VToDo> validator = methodValidators.get(method);
        if (validator != null) {
            return validator.validate(this);
        }
        return super.validate(method);
    }

    @Deprecated
    public final Optional<Completed> getDateCompleted() {
        return this.getDateTimeCompleted();
    }

    @Deprecated
    public final <T extends Temporal> Optional<DtStart<T>> getStartDate() {
        return this.getDateTimeStart();
    }

    @Deprecated
    public final Optional<DtStamp> getDateStamp() {
        return this.getDateTimeStamp();
    }

    @Deprecated
    public final <T extends Temporal> Optional<Due<T>> getDue() {
        return this.getDateTimeDue();
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 instanceof VToDo) {
            return super.equals(arg0) && Objects.equals(this.getAlarms(), ((VToDo)arg0).getAlarms());
        }
        return super.equals(arg0);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getName()).append(this.getProperties()).append(this.getAlarms()).toHashCode();
    }

    protected ComponentFactory<VToDo> newFactory() {
        return new Factory();
    }

    @Override
    public Component copy() {
        return this.newFactory().createComponent(new PropertyList(this.getProperties().parallelStream().map(Property::copy).collect(Collectors.toList())), new ComponentList(this.getComponents(new String[0]).parallelStream().map(Component::copy).collect(Collectors.toList())));
    }

    static {
        methodValidators.put(ImmutableMethod.ADD, new VToDoValidator(new ValidationRule(ValidationRule.ValidationType.One, "DTSTAMP", "ORGANIZER", "PRIORITY", "SEQUENCE", "SUMMARY", "UID"), new ValidationRule(ValidationRule.ValidationType.OneOrLess, "CATEGORIES", "CLASS", "CREATED", "DESCRIPTION", "DTSTART", "DUE", "DURATION", "GEO", "LAST-MODIFIED", "LOCATION", "PERCENT-COMPLETE", "RESOURCES", "STATUS", "URL"), new ValidationRule(ValidationRule.ValidationType.None, "RECURRENCE-ID", "REQUEST-STATUS")));
        methodValidators.put(ImmutableMethod.CANCEL, new VToDoValidator(false, new ValidationRule(ValidationRule.ValidationType.One, "UID", "DTSTAMP", "ORGANIZER", "SEQUENCE"), new ValidationRule(ValidationRule.ValidationType.OneOrLess, "CATEGORIES", "CLASS", "CREATED", "DESCRIPTION", "DTSTART", "DUE", "DURATION", "GEO", "LAST-MODIFIED", "LOCATION", "PERCENT-COMPLETE", "RECURRENCE-ID", "RESOURCES", "PRIORITY", "STATUS", "URL"), new ValidationRule(ValidationRule.ValidationType.None, "REQUEST-STATUS")));
        methodValidators.put(ImmutableMethod.COUNTER, new VToDoValidator(new ValidationRule(ValidationRule.ValidationType.OneOrMore, "ATTENDEE"), new ValidationRule(ValidationRule.ValidationType.One, "DTSTAMP", "ORGANIZER", "PRIORITY", "SUMMARY", "UID"), new ValidationRule(ValidationRule.ValidationType.OneOrLess, "CATEGORIES", "CLASS", "CREATED", "DESCRIPTION", "DTSTART", "DUE", "DURATION", "GEO", "LAST-MODIFIED", "LOCATION", "PERCENT-COMPLETE", "RECURRENCE-ID", "RESOURCES", "RRULE", "SEQUENCE", "STATUS", "URL")));
        methodValidators.put(ImmutableMethod.DECLINE_COUNTER, new VToDoValidator(false, new ValidationRule(ValidationRule.ValidationType.OneOrMore, "ATTENDEE"), new ValidationRule(ValidationRule.ValidationType.One, "DTSTAMP", "ORGANIZER", "SEQUENCE", "UID"), new ValidationRule(ValidationRule.ValidationType.OneOrLess, "CATEGORIES", "CLASS", "CREATED", "DESCRIPTION", "DTSTART", "DUE", "DURATION", "GEO", "LAST-MODIFIED", "LOCATION", "LOCATION", "PERCENT-COMPLETE", "PRIORITY", "RECURRENCE-ID", "RESOURCES", "STATUS", "URL")));
        methodValidators.put(ImmutableMethod.PUBLISH, new VToDoValidator(new ValidationRule(ValidationRule.ValidationType.One, "DTSTAMP", "SUMMARY", "UID"), new ValidationRule(ValidationRule.ValidationType.One, true, "ORGANIZER", "PRIORITY"), new ValidationRule(ValidationRule.ValidationType.OneOrLess, "DTSTART", "SEQUENCE", "CATEGORIES", "CLASS", "CREATED", "DESCRIPTION", "DUE", "DURATION", "GEO", "LAST-MODIFIED", "LOCATION", "PERCENT-COMPLETE", "RECURRENCE-ID", "RESOURCES", "STATUS", "URL"), new ValidationRule(ValidationRule.ValidationType.None, "ATTENDEE", "REQUEST-STATUS")));
        methodValidators.put(ImmutableMethod.REFRESH, new VToDoValidator(false, new ValidationRule(ValidationRule.ValidationType.One, "ATTENDEE", "DTSTAMP", "UID"), new ValidationRule(ValidationRule.ValidationType.OneOrLess, "RECURRENCE-ID"), new ValidationRule(ValidationRule.ValidationType.None, "ATTACH", "CATEGORIES", "CLASS", "CONTACT", "CREATED", "DESCRIPTION", "DTSTART", "DUE", "DURATION", "EXDATE", "EXRULE", "GEO", "LAST-MODIFIED", "LOCATION", "ORGANIZER", "PERCENT-COMPLETE", "PRIORITY", "RDATE", "RELATED-TO", "REQUEST-STATUS", "RESOURCES", "RRULE", "SEQUENCE", "STATUS", "URL")));
        methodValidators.put(ImmutableMethod.REPLY, new VToDoValidator(false, new ValidationRule(ValidationRule.ValidationType.OneOrMore, "ATTENDEE"), new ValidationRule(ValidationRule.ValidationType.One, "DTSTAMP", "ORGANIZER", "UID"), new ValidationRule(ValidationRule.ValidationType.OneOrLess, "CATEGORIES", "CLASS", "CREATED", "DESCRIPTION", "DTSTART", "DUE", "DURATION", "GEO", "LAST-MODIFIED", "LOCATION", "PERCENT-COMPLETE", "PRIORITY", "RESOURCES", "RECURRENCE-ID", "SEQUENCE", "STATUS", "SUMMARY", "URL")));
        methodValidators.put(ImmutableMethod.REQUEST, new VToDoValidator(new ValidationRule(ValidationRule.ValidationType.OneOrMore, "ATTENDEE"), new ValidationRule(ValidationRule.ValidationType.One, "DTSTAMP", "DTSTART", "ORGANIZER", "PRIORITY", "SUMMARY", "UID"), new ValidationRule(ValidationRule.ValidationType.OneOrLess, "SEQUENCE", "CATEGORIES", "CLASS", "CREATED", "DESCRIPTION", "DUE", "DURATION", "GEO", "LAST-MODIFIED", "LOCATION", "PERCENT-COMPLETE", "RECURRENCE-ID", "RESOURCES", "STATUS", "URL"), new ValidationRule(ValidationRule.ValidationType.None, "REQUEST-STATUS")));
    }

    public static class Factory
    extends Content.Factory
    implements ComponentFactory<VToDo> {
        public Factory() {
            super("VTODO");
        }

        @Override
        public VToDo createComponent() {
            return new VToDo(false);
        }

        @Override
        public VToDo createComponent(PropertyList properties) {
            return new VToDo(properties);
        }

        @Override
        public VToDo createComponent(PropertyList properties, ComponentList<?> subComponents) {
            return new VToDo(properties, subComponents);
        }
    }
}

