/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.parameter;

import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Encodable;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterFactory;
import net.fortuna.ical4j.util.Strings;

public class CuType
extends Parameter
implements Encodable {
    private static final long serialVersionUID = -3134064324693983052L;
    private static final String VALUE_INDIVIDUAL = "INDIVIDUAL";
    private static final String VALUE_GROUP = "GROUP";
    private static final String VALUE_RESOURCE = "RESOURCE";
    private static final String VALUE_ROOM = "ROOM";
    private static final String VALUE_UNKNOWN = "UNKNOWN";
    public static final CuType INDIVIDUAL = new CuType("INDIVIDUAL");
    public static final CuType GROUP = new CuType("GROUP");
    public static final CuType RESOURCE = new CuType("RESOURCE");
    public static final CuType ROOM = new CuType("ROOM");
    public static final CuType UNKNOWN = new CuType("UNKNOWN");
    private final String value;

    public CuType(String aValue) {
        super("CUTYPE");
        this.value = Strings.unquote(aValue);
    }

    @Override
    public final String getValue() {
        return this.value;
    }

    public static class Factory
    extends Content.Factory
    implements ParameterFactory<CuType> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super("CUTYPE");
        }

        @Override
        public CuType createParameter(String value) {
            switch (value.toUpperCase()) {
                case "INDIVIDUAL": {
                    return INDIVIDUAL;
                }
                case "GROUP": {
                    return GROUP;
                }
                case "RESOURCE": {
                    return RESOURCE;
                }
                case "ROOM": {
                    return ROOM;
                }
                case "UNKNOWN": {
                    return UNKNOWN;
                }
            }
            return new CuType(value);
        }
    }
}

