/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.parameter;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.fortuna.ical4j.model.AddressList;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterFactory;
import net.fortuna.ical4j.util.Strings;

public class DelegatedFrom
extends Parameter {
    private static final long serialVersionUID = -795956139235258568L;
    private final List<URI> delegators;

    public DelegatedFrom(String aValue) {
        super("DELEGATED-FROM");
        try {
            this.delegators = new AddressList(Strings.unquote(aValue)).getAddresses();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public DelegatedFrom(List<URI> aList) {
        super("DELEGATED-FROM");
        this.delegators = aList;
    }

    public final List<URI> getDelegators() {
        return new ArrayList<URI>(this.delegators);
    }

    @Override
    public final String getValue() {
        return AddressList.toString(this.delegators);
    }

    public static class Factory
    extends Content.Factory
    implements ParameterFactory<DelegatedFrom> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super("DELEGATED-FROM");
        }

        @Override
        public DelegatedFrom createParameter(String value) {
            return new DelegatedFrom(value);
        }
    }
}

