/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.parameter;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.fortuna.ical4j.model.AddressList;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterFactory;
import net.fortuna.ical4j.util.Strings;

public class DelegatedTo
extends Parameter {
    private static final long serialVersionUID = 567577003350648021L;
    private final List<URI> delegatees;

    public DelegatedTo(String aValue) {
        super("DELEGATED-TO");
        try {
            this.delegatees = new AddressList(Strings.unquote(aValue)).getAddresses();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public DelegatedTo(List<URI> aList) {
        super("DELEGATED-TO");
        this.delegatees = aList;
    }

    public final List<URI> getDelegatees() {
        return new ArrayList<URI>(this.delegatees);
    }

    @Override
    public final String getValue() {
        return AddressList.toString(this.delegatees);
    }

    public static class Factory
    extends Content.Factory
    implements ParameterFactory<DelegatedTo> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super("DELEGATED-TO");
        }

        @Override
        public DelegatedTo createParameter(String value) {
            return new DelegatedTo(value);
        }
    }
}

