/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.parameter;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Encodable;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterFactory;

public class Display
extends Parameter
implements Encodable {
    private static final long serialVersionUID = 1L;
    private static final String PARAMETER_NAME = "DISPLAY";
    private final Set<String> values;

    public Display(String value) {
        super(PARAMETER_NAME);
        String[] valueStrings;
        for (String valueString : valueStrings = value.split("\\s*,\\s*")) {
            try {
                Value.valueOf(valueString.toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                if (valueString.startsWith("X-")) continue;
                throw iae;
            }
        }
        this.values = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(valueStrings)));
    }

    @Override
    public String getValue() {
        return String.join((CharSequence)",", this.values);
    }

    public static enum Value {
        BADGE,
        GRAPHIC,
        FULLSIZE,
        THUMBNAIL;

    }

    public static class Factory
    extends Content.Factory
    implements ParameterFactory<Display> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super(Display.PARAMETER_NAME);
        }

        @Override
        public Display createParameter(String value) {
            return new Display(value);
        }
    }
}

