/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.parameter;

import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Encodable;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterFactory;
import net.fortuna.ical4j.util.Strings;

public class Encoding
extends Parameter
implements Encodable {
    private static final long serialVersionUID = 7536336461076399077L;
    private static final String VALUE_SEVEN_BIT = "7BIT";
    private static final String VALUE_EIGHT_BIT = "8BIT";
    private static final String VALUE_BINARY = "BINARY";
    private static final String VALUE_QUOTED_PRINTABLE = "QUOTED-PRINTABLE";
    private static final String VALUE_BASE64 = "BASE64";
    public static final Encoding SEVEN_BIT = new Encoding("7BIT");
    public static final Encoding EIGHT_BIT = new Encoding("8BIT");
    public static final Encoding BINARY = new Encoding("BINARY");
    public static final Encoding QUOTED_PRINTABLE = new Encoding("QUOTED-PRINTABLE");
    public static final Encoding BASE64 = new Encoding("BASE64");
    private final String value;

    public Encoding(String aValue) {
        super("ENCODING");
        this.value = Strings.unquote(aValue);
    }

    @Override
    public final String getValue() {
        return this.value;
    }

    public static class Factory
    extends Content.Factory
    implements ParameterFactory<Encoding> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super("ENCODING");
        }

        @Override
        public Encoding createParameter(String value) {
            switch (value.toUpperCase()) {
                case "BASE64": {
                    return BASE64;
                }
                case "BINARY": {
                    return BINARY;
                }
                case "8BIT": {
                    return EIGHT_BIT;
                }
                case "QUOTED-PRINTABLE": {
                    return QUOTED_PRINTABLE;
                }
                case "7BIT": {
                    return SEVEN_BIT;
                }
            }
            return new Encoding(value);
        }
    }
}

