/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.parameter;

import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Encodable;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterFactory;
import net.fortuna.ical4j.util.Strings;

public class FbType
extends Parameter
implements Encodable {
    private static final long serialVersionUID = -2217689716824679375L;
    private static final String VALUE_FREE = "FREE";
    private static final String VALUE_BUSY = "BUSY";
    private static final String VALUE_BUSY_UNAVAILABLE = "BUSY-UNAVAILABLE";
    private static final String VALUE_BUSY_TENTATIVE = "BUSY-TENTATIVE";
    public static final FbType FREE = new FbType("FREE");
    public static final FbType BUSY = new FbType("BUSY");
    public static final FbType BUSY_UNAVAILABLE = new FbType("BUSY-UNAVAILABLE");
    public static final FbType BUSY_TENTATIVE = new FbType("BUSY-TENTATIVE");
    private final String value;

    public FbType(String aValue) {
        super("FBTYPE");
        this.value = Strings.unquote(aValue);
    }

    @Override
    public final String getValue() {
        return this.value;
    }

    public static class Factory
    extends Content.Factory
    implements ParameterFactory<FbType> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super("FBTYPE");
        }

        @Override
        public FbType createParameter(String value) {
            switch (value.toUpperCase()) {
                case "BUSY": {
                    return BUSY;
                }
                case "BUSY-TENTATIVE": {
                    return BUSY_TENTATIVE;
                }
                case "BUSY-UNAVAILABLE": {
                    return BUSY_UNAVAILABLE;
                }
                case "FREE": {
                    return FREE;
                }
            }
            return new FbType(value);
        }
    }
}

