/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.parameter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Encodable;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterFactory;

public class Feature
extends Parameter
implements Encodable {
    private static final long serialVersionUID = 1L;
    private static final String PARAMETER_NAME = "FEATURE";
    public static final Feature AUDIO = new Feature(Value.AUDIO.name());
    public static final Feature CHAT = new Feature(Value.CHAT.name());
    public static final Feature FEED = new Feature(Value.FEED.name());
    public static final Feature MODERATOR = new Feature(Value.MODERATOR.name());
    public static final Feature PHONE = new Feature(Value.PHONE.name());
    public static final Feature SCREEN = new Feature(Value.SCREEN.name());
    public static final Feature VIDEO = new Feature(Value.VIDEO.name());
    private final Set<String> values;

    public Feature(String value) {
        this(value.split("\\s*,\\s*"));
    }

    public Feature(String ... valueStrings) {
        super(PARAMETER_NAME);
        for (String valueString : valueStrings) {
            try {
                Value.valueOf(valueString.toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                if (valueString.startsWith("X-")) continue;
                throw iae;
            }
        }
        this.values = Collections.unmodifiableSet(new TreeSet<String>(Arrays.asList(valueStrings)));
    }

    public Feature(Value ... values) {
        super(PARAMETER_NAME);
        this.values = Collections.unmodifiableSet(new TreeSet(Arrays.stream(values).map(Enum::name).collect(Collectors.toList())));
    }

    @Override
    public String getValue() {
        return String.join((CharSequence)",", this.values);
    }

    public static enum Value {
        AUDIO,
        CHAT,
        FEED,
        MODERATOR,
        PHONE,
        SCREEN,
        VIDEO;

    }

    public static class Factory
    extends Content.Factory
    implements ParameterFactory<Feature> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super(Feature.PARAMETER_NAME);
        }

        @Override
        public Feature createParameter(String value) {
            return new Feature(value);
        }
    }
}

